package ru.yandex.direct.ess.router.rules.bsexport.adgroup.showconditions

import org.jooq.Field
import org.springframework.stereotype.Component
import ru.yandex.direct.binlog.model.Operation
import ru.yandex.direct.dbschema.ppc.Tables.BANNERS
import ru.yandex.direct.dbschema.ppc.Tables.BANNERS_MINUS_GEO
import ru.yandex.direct.dbschema.ppc.Tables.BANNERS_PERFORMANCE
import ru.yandex.direct.dbschema.ppc.Tables.BANNER_PERMALINKS
import ru.yandex.direct.dbschema.ppc.Tables.BANNER_TURBOLANDINGS
import ru.yandex.direct.dbschema.ppc.Tables.IMAGES
import ru.yandex.direct.dbschema.ppc.Tables.PHRASES
import ru.yandex.direct.ess.logicobjects.bsexport.adgroup.AdGroupShowConditionType
import ru.yandex.direct.ess.logicobjects.bsexport.adgroup.BsExportAdGroupShowConditionObject
import ru.yandex.direct.ess.router.rules.bsexport.extractDebugInfo
import ru.yandex.direct.ess.router.utils.ColumnsChangeType
import ru.yandex.direct.ess.router.utils.ProceededChange
import ru.yandex.direct.ess.router.utils.TableChange
import ru.yandex.direct.ess.router.utils.TableChangesHandler

@Component
class AdGroupShowConditionGeoFilter : AdGroupShowConditionFilter {
    override fun configure(tableChangesHandler: TableChangesHandler<BsExportAdGroupShowConditionObject>) {
        tableChangesHandler.addTableChange(
            TableChange.Builder<BsExportAdGroupShowConditionObject>()
                .setTable(PHRASES)
                .setOperation(Operation.INSERT)
                .setMapper(this::mapToObject)
                .build()
        )
        tableChangesHandler.addTableChange(
            TableChange.Builder<BsExportAdGroupShowConditionObject>()
                .setTable(PHRASES)
                .setOperation(Operation.UPDATE)
                .setColumns(ColumnsChangeType.ANY, listOf(PHRASES.GEO, PHRASES.STATUS_POST_MODERATE))
                .setMapper(this::mapToObject)
                .build()
        )
        tableChangesHandler.addTableChange(
            TableChange.Builder<BsExportAdGroupShowConditionObject>()
                .setTable(PHRASES)
                .setOperation(Operation.DELETE)
                .setMapper(this::mapToObject)
                .build()
        )
        tableChangesHandler.addTableChange(
            TableChange.Builder<BsExportAdGroupShowConditionObject>()
                .setTable(BANNERS)
                .setOperation(Operation.UPDATE)
                .setColumns(ColumnsChangeType.ANY, listOf(
                    BANNERS.STATUS_POST_MODERATE,
                    BANNERS.STATUS_SHOW,
                    BANNERS.STATUS_ARCH,
                    BANNERS.HREF,
                    BANNERS.PHONEFLAG,
                    BANNERS.VCARD_ID,
                ))
                .setMapper(this::mapBannerToObject)
                .build()
        )
        tableChangesHandler.addTableChange(
            TableChange.Builder<BsExportAdGroupShowConditionObject>()
                .setTable(BANNERS)
                .setOperation(Operation.DELETE)
                .setMapper(this::mapBannerToObject)
                .build()
        )
        tableChangesHandler.addTableChange(
            TableChange.Builder<BsExportAdGroupShowConditionObject>()
                .setTable(BANNERS_MINUS_GEO)
                .setOperation(Operation.INSERT)
                .setMapper(bannerIdToObject(BANNERS_MINUS_GEO.BID, true))
                .build()
        )
        tableChangesHandler.addTableChange(
            TableChange.Builder<BsExportAdGroupShowConditionObject>()
                .setTable(BANNERS_MINUS_GEO)
                .setOperation(Operation.UPDATE)
                .setColumns(ColumnsChangeType.ANY, listOf(BANNERS_MINUS_GEO.MINUS_GEO))
                .setMapper(bannerIdToObject(BANNERS_MINUS_GEO.BID, true))
                .build()
        )
        tableChangesHandler.addTableChange(
            TableChange.Builder<BsExportAdGroupShowConditionObject>()
                .setTable(BANNERS_MINUS_GEO)
                .setOperation(Operation.DELETE)
                .setMapper(bannerIdToObject(BANNERS_MINUS_GEO.BID, true))
                .build()
        )
        tableChangesHandler.addTableChange(
            TableChange.Builder<BsExportAdGroupShowConditionObject>()
                .setTable(IMAGES)
                .setOperation(Operation.INSERT)
                .setMapper(bannerIdToObject(IMAGES.BID, false))
                .build()
        )
        tableChangesHandler.addTableChange(
            TableChange.Builder<BsExportAdGroupShowConditionObject>()
                .setTable(IMAGES)
                .setOperation(Operation.UPDATE)
                .setColumns(ColumnsChangeType.ANY, listOf(IMAGES.STATUS_MODERATE))
                .setMapper(bannerIdToObject(IMAGES.BID, false))
                .build()
        )
        tableChangesHandler.addTableChange(
            TableChange.Builder<BsExportAdGroupShowConditionObject>()
                .setTable(IMAGES)
                .setOperation(Operation.DELETE)
                .setMapper(bannerIdToObject(IMAGES.BID, false))
                .build()
        )
        tableChangesHandler.addTableChange(
            TableChange.Builder<BsExportAdGroupShowConditionObject>()
                .setTable(BANNERS_PERFORMANCE)
                .setOperation(Operation.INSERT)
                .setMapper(bannerIdToObject(BANNERS_PERFORMANCE.BID, false))
                .build()
        )
        tableChangesHandler.addTableChange(
            TableChange.Builder<BsExportAdGroupShowConditionObject>()
                .setTable(BANNERS_PERFORMANCE)
                .setOperation(Operation.UPDATE)
                .setColumns(ColumnsChangeType.ANY, listOf(BANNERS_PERFORMANCE.STATUS_MODERATE))
                .setMapper(bannerIdToObject(BANNERS_PERFORMANCE.BID, false))
                .build()
        )
        tableChangesHandler.addTableChange(
            TableChange.Builder<BsExportAdGroupShowConditionObject>()
                .setTable(BANNER_TURBOLANDINGS)
                .setOperation(Operation.INSERT)
                .setMapper(bannerIdToObject(BANNER_TURBOLANDINGS.BID, true))
                .build()
        )
        tableChangesHandler.addTableChange(
            TableChange.Builder<BsExportAdGroupShowConditionObject>()
                .setTable(BANNER_TURBOLANDINGS)
                .setOperation(Operation.UPDATE)
                .setColumns(ColumnsChangeType.ANY, listOf(BANNER_TURBOLANDINGS.STATUS_MODERATE))
                .setMapper(bannerIdToObject(BANNER_TURBOLANDINGS.BID, true))
                .build()
        )
        tableChangesHandler.addTableChange(
            TableChange.Builder<BsExportAdGroupShowConditionObject>()
                .setTable(BANNER_TURBOLANDINGS)
                .setOperation(Operation.DELETE)
                .setMapper(bannerIdToObject(BANNER_TURBOLANDINGS.BID, true))
                .build()
        )
        tableChangesHandler.addTableChange(
            TableChange.Builder<BsExportAdGroupShowConditionObject>()
                .setTable(BANNER_PERMALINKS)
                .setOperation(Operation.INSERT)
                .setMapper(bannerIdToObject(BANNER_PERMALINKS.BID, true))
                .build()
        )
        tableChangesHandler.addTableChange(
            TableChange.Builder<BsExportAdGroupShowConditionObject>()
                .setTable(BANNER_PERMALINKS)
                .setOperation(Operation.UPDATE)
                .setColumns(ColumnsChangeType.ANY, listOf(
                    BANNER_PERMALINKS.PERMALINK_ASSIGN_TYPE,
                    BANNER_PERMALINKS.PREFER_VCARD_OVER_PERMALINK,
                ))
                .setMapper(bannerIdToObject(BANNER_PERMALINKS.BID, true))
                .build()
        )
        tableChangesHandler.addTableChange(
            TableChange.Builder<BsExportAdGroupShowConditionObject>()
                .setTable(BANNER_PERMALINKS)
                .setOperation(Operation.DELETE)
                .setMapper(bannerIdToObject(BANNER_PERMALINKS.BID, true))
                .build()
        )
    }

    private fun mapToObject(proceededChange: ProceededChange): BsExportAdGroupShowConditionObject {
        val adGroupId: Long = proceededChange.getPrimaryKey(PHRASES.PID)
        val campaignId: Long = proceededChange.getBeforeOrAfter(PHRASES.CID)
        val debugInfo = extractDebugInfo(proceededChange)
        return BsExportAdGroupShowConditionObject(adGroupId, campaignId, AdGroupShowConditionType.GEO, debugInfo)
    }

    private fun mapBannerToObject(proceededChange: ProceededChange): BsExportAdGroupShowConditionObject {
        val adGroupId: Long = proceededChange.getBeforeOrAfter(BANNERS.PID)
        val campaignId: Long = proceededChange.getBeforeOrAfter(BANNERS.CID)
        val debugInfo = extractDebugInfo(proceededChange)
        return BsExportAdGroupShowConditionObject(adGroupId, campaignId, AdGroupShowConditionType.GEO, debugInfo)
    }

    private fun <T> bannerIdToObject(column: Field<T>, isPrimary: Boolean): ((ProceededChange) -> BsExportAdGroupShowConditionObject) {
        return { proceededChange: ProceededChange ->
            val bannerId: Long = if (isPrimary) {
                proceededChange.getPrimaryKey(column)
            } else {
                proceededChange.getBeforeOrAfter(column)
            }
            val debugInfo = extractDebugInfo(proceededChange)
            BsExportAdGroupShowConditionObject(
                adGroupId = null,
                campaignId = null,
                bannerId = bannerId,
                type = AdGroupShowConditionType.GEO,
                debugInfo = debugInfo)
        }
    }
}
