package ru.yandex.direct.ess.router.rules.bsexport.adgroup.showconditions

import org.springframework.stereotype.Component
import ru.yandex.direct.binlog.model.Operation
import ru.yandex.direct.dbschema.ppc.Tables
import ru.yandex.direct.dbschema.ppc.Tables.BIDS_RETARGETING
import ru.yandex.direct.ess.logicobjects.bsexport.adgroup.AdGroupShowConditionType
import ru.yandex.direct.ess.logicobjects.bsexport.adgroup.BsExportAdGroupShowConditionObject
import ru.yandex.direct.ess.router.rules.bsexport.adgroup.showconditions.AdGroupShowConditionFilter
import ru.yandex.direct.ess.router.rules.bsexport.extractDebugInfo
import ru.yandex.direct.ess.router.utils.ProceededChange
import ru.yandex.direct.ess.router.utils.TableChange
import ru.yandex.direct.ess.router.utils.TableChangesHandler

@Component
class AdGroupShowConditionGoalContextFilter : AdGroupShowConditionFilter {
    override fun configure(tableChangesHandler: TableChangesHandler<BsExportAdGroupShowConditionObject>) {
        tableChangesHandler.addTableChange(
            TableChange.Builder<BsExportAdGroupShowConditionObject>()
                .setTable(BIDS_RETARGETING)
                .setOperation(Operation.INSERT)
                .setMapper(this::mapToObject)
                .build()
        )
        tableChangesHandler.addTableChange(
            TableChange.Builder<BsExportAdGroupShowConditionObject>()
                .setTable(BIDS_RETARGETING)
                .setOperation(Operation.DELETE)
                .setMapper(this::mapToObject)
                .build()
        )
        tableChangesHandler.addTableChange(
            TableChange.Builder<BsExportAdGroupShowConditionObject>()
                .setTable(Tables.ADGROUPS_INTERNAL)
                .setOperation(Operation.DELETE)
                .setMapper(this::mapAdGroupsToObject)
                .build()
        )
        tableChangesHandler.addTableChange(
            TableChange.Builder<BsExportAdGroupShowConditionObject>()
                .setTable(Tables.PHRASES)
                .setOperation(Operation.DELETE)
                .setMapper(this::mapPhrasesToObject)
                .build()
        )
    }

    private fun mapToObject(proceededChange: ProceededChange): BsExportAdGroupShowConditionObject {
        val adGroupId: Long = proceededChange.getBeforeOrAfter(BIDS_RETARGETING.PID)
        val debugInfo = extractDebugInfo(proceededChange)
        return BsExportAdGroupShowConditionObject(
            adGroupId,
            null,
            AdGroupShowConditionType.GOAL_CONTEXT,
            debugInfo)
    }

    private fun mapPhrasesToObject(proceededChange: ProceededChange): BsExportAdGroupShowConditionObject {
        val adGroupId: Long = proceededChange.getPrimaryKey(Tables.PHRASES.PID)
        val campaignId: Long = proceededChange.getBeforeOrAfter(Tables.PHRASES.CID)
        val debugInfo = extractDebugInfo(proceededChange)
        return BsExportAdGroupShowConditionObject(
            adGroupId,
            campaignId,
            AdGroupShowConditionType.GOAL_CONTEXT,
            debugInfo)
    }

    private fun mapAdGroupsToObject(proceededChange: ProceededChange): BsExportAdGroupShowConditionObject {
        val adGroupId: Long = proceededChange.getPrimaryKey(Tables.ADGROUPS_INTERNAL.PID)
        val debugInfo = extractDebugInfo(proceededChange)
        return BsExportAdGroupShowConditionObject(
            adGroupId,
            null,
            AdGroupShowConditionType.GOAL_CONTEXT,
            debugInfo)
    }
}

