package ru.yandex.direct.ess.router.rules.bsexport.adgroup.showconditions

import org.springframework.stereotype.Component
import ru.yandex.direct.binlog.model.Operation
import ru.yandex.direct.dbschema.ppc.Tables.ADGROUPS_INTERNAL
import ru.yandex.direct.dbschema.ppc.Tables.PHRASES
import ru.yandex.direct.ess.logicobjects.bsexport.adgroup.AdGroupShowConditionType
import ru.yandex.direct.ess.logicobjects.bsexport.adgroup.BsExportAdGroupShowConditionObject
import ru.yandex.direct.ess.router.rules.bsexport.extractDebugInfo
import ru.yandex.direct.ess.router.utils.ColumnsChangeType
import ru.yandex.direct.ess.router.utils.ProceededChange
import ru.yandex.direct.ess.router.utils.TableChange
import ru.yandex.direct.ess.router.utils.TableChangesHandler

/**
 * простые поля для внутренней рекламы
 */
@Component
class AdGroupShowConditionInternalFilter : AdGroupShowConditionFilter {
    override fun configure(tableChangesHandler: TableChangesHandler<BsExportAdGroupShowConditionObject>) {
        val typeToCols = mapOf(
            AdGroupShowConditionType.RF to listOf(ADGROUPS_INTERNAL.RF, ADGROUPS_INTERNAL.RF_RESET),
            AdGroupShowConditionType.TIME to listOf(ADGROUPS_INTERNAL.START_TIME, ADGROUPS_INTERNAL.FINISH_TIME),
        )

        typeToCols.forEach { (type, cols) ->
            tableChangesHandler.addTableChange(
                TableChange.Builder<BsExportAdGroupShowConditionObject>()
                    .setTable(ADGROUPS_INTERNAL)
                    .setOperation(Operation.INSERT)
                    .setMapper{ mapToObjectAdGroupInternal(it, type) }
                    .build()
            )
            tableChangesHandler.addTableChange(
                TableChange.Builder<BsExportAdGroupShowConditionObject>()
                    .setTable(ADGROUPS_INTERNAL)
                    .setOperation(Operation.UPDATE)
                    .setColumns(ColumnsChangeType.ANY, cols)
                    .setMapper{ mapToObjectAdGroupInternal(it, type) }
                    .build()
            )
            tableChangesHandler.addTableChange(
                TableChange.Builder<BsExportAdGroupShowConditionObject>()
                    .setTable(ADGROUPS_INTERNAL)
                    .setOperation(Operation.DELETE)
                    .setMapper{ mapToObjectAdGroupInternal(it, type) }
                    .build()
            )
            tableChangesHandler.addTableChange(
                TableChange.Builder<BsExportAdGroupShowConditionObject>()
                    .setTable(PHRASES)
                    .setOperation(Operation.DELETE)
                    .setMapper{ mapToObjectPhrases(it, type) }
                    .build()
            )
        }
    }

    private fun mapToObjectAdGroupInternal(proceededChange: ProceededChange, type: AdGroupShowConditionType): BsExportAdGroupShowConditionObject {
        val adGroupId: Long = proceededChange.getPrimaryKey(ADGROUPS_INTERNAL.PID)
        val debugInfo = extractDebugInfo(proceededChange)
        return BsExportAdGroupShowConditionObject(adGroupId, campaignId = null, type, debugInfo)
    }

    private fun mapToObjectPhrases(proceededChange: ProceededChange, type: AdGroupShowConditionType): BsExportAdGroupShowConditionObject {
        val adGroupId: Long = proceededChange.getPrimaryKey(PHRASES.PID)
        val campaignId: Long = proceededChange.getBeforeOrAfter(PHRASES.CID)
        val debugInfo = extractDebugInfo(proceededChange)
        return BsExportAdGroupShowConditionObject(adGroupId, campaignId, type, debugInfo)
    }
}
