package ru.yandex.direct.ess.router.rules.bsexport.adgroup.showconditions

import org.springframework.stereotype.Component
import ru.yandex.direct.binlog.model.Operation
import ru.yandex.direct.dbschema.ppc.Tables.ADGROUPS_MOBILE_CONTENT
import ru.yandex.direct.dbschema.ppc.Tables.MOBILE_CONTENT
import ru.yandex.direct.ess.logicobjects.bsexport.adgroup.AdGroupShowConditionType
import ru.yandex.direct.ess.logicobjects.bsexport.adgroup.BsExportAdGroupShowConditionObject
import ru.yandex.direct.ess.router.rules.bsexport.extractDebugInfo
import ru.yandex.direct.ess.router.utils.ColumnsChangeType
import ru.yandex.direct.ess.router.utils.ProceededChange
import ru.yandex.direct.ess.router.utils.TableChange
import ru.yandex.direct.ess.router.utils.TableChangesHandler

@Component
class AdGroupShowConditionMobileContentFilter : AdGroupShowConditionFilter {
    override fun configure(tableChangesHandler: TableChangesHandler<BsExportAdGroupShowConditionObject>) {
        tableChangesHandler.addTableChange(
            TableChange.Builder<BsExportAdGroupShowConditionObject>()
                .setTable(ADGROUPS_MOBILE_CONTENT)
                .setOperation(Operation.INSERT)
                .setMapper(this::additionalTargetingToObject)
                .build()
        )
        tableChangesHandler.addTableChange(
            TableChange.Builder<BsExportAdGroupShowConditionObject>()
                .setTable(ADGROUPS_MOBILE_CONTENT)
                .setOperation(Operation.UPDATE)
                .setColumns(ColumnsChangeType.ANY, listOf(
                    ADGROUPS_MOBILE_CONTENT.MIN_OS_VERSION,
                    ADGROUPS_MOBILE_CONTENT.NETWORK_TARGETING,
                    ADGROUPS_MOBILE_CONTENT.DEVICE_TYPE_TARGETING,
                ))
                .setMapper(this::additionalTargetingToObject)
                .build()
        )
        tableChangesHandler.addTableChange(
            TableChange.Builder<BsExportAdGroupShowConditionObject>()
                .setTable(MOBILE_CONTENT)
                .setOperation(Operation.UPDATE)
                .setColumns(ColumnsChangeType.ANY, listOf(
                    MOBILE_CONTENT.OS_TYPE,
                    MOBILE_CONTENT.BUNDLE_ID,
                    MOBILE_CONTENT.STORE_CONTENT_ID,
                    MOBILE_CONTENT.MIN_OS_VERSION,
                ))
                .setMapper(this::mobileContentToObject)
                .build()
        )
    }

    private fun additionalTargetingToObject(proceededChange: ProceededChange): BsExportAdGroupShowConditionObject {
        val adGroupId: Long = proceededChange.getPrimaryKey(ADGROUPS_MOBILE_CONTENT.PID)
        val debugInfo = extractDebugInfo(proceededChange)
        return BsExportAdGroupShowConditionObject(
            adGroupId,
            campaignId = null,
            AdGroupShowConditionType.MOBILE_CONTENT,
            debugInfo,
        )
    }

    private fun mobileContentToObject(proceededChange: ProceededChange): BsExportAdGroupShowConditionObject {
        val mobileContentId: Long = proceededChange.getLongPrimaryKey(MOBILE_CONTENT.MOBILE_CONTENT_ID)
        val debugInfo = extractDebugInfo(proceededChange)
        return BsExportAdGroupShowConditionObject(
            adGroupId = null,
            campaignId = null,
            AdGroupShowConditionType.MOBILE_CONTENT,
            debugInfo,
            mobileContentId = mobileContentId
        )
    }
}
