package ru.yandex.direct.ess.router.rules.bsexport.adgroup.showconditions

import org.springframework.stereotype.Component
import ru.yandex.direct.binlog.model.Operation
import ru.yandex.direct.dbschema.ppc.Tables.ADGROUP_PAGE_TARGETS
import ru.yandex.direct.ess.logicobjects.bsexport.adgroup.AdGroupShowConditionType
import ru.yandex.direct.ess.logicobjects.bsexport.adgroup.BsExportAdGroupShowConditionObject
import ru.yandex.direct.ess.router.rules.bsexport.extractDebugInfo
import ru.yandex.direct.ess.router.utils.ColumnsChangeType
import ru.yandex.direct.ess.router.utils.ProceededChange
import ru.yandex.direct.ess.router.utils.TableChange
import ru.yandex.direct.ess.router.utils.TableChangesHandler

@Component
class AdGroupShowConditionPageBlocksFilter : AdGroupShowConditionFilter {
    override fun configure(tableChangesHandler: TableChangesHandler<BsExportAdGroupShowConditionObject>) {
        tableChangesHandler.addTableChange(
            TableChange.Builder<BsExportAdGroupShowConditionObject>()
                .setTable(ADGROUP_PAGE_TARGETS)
                .setOperation(Operation.UPDATE)
                .setColumn(ADGROUP_PAGE_TARGETS.PAGE_BLOCKS)
                .setMapper(this::mapToObject)
                .build()
        )
        tableChangesHandler.addTableChange(
            TableChange.Builder<BsExportAdGroupShowConditionObject>()
                .setTable(ADGROUP_PAGE_TARGETS)
                .setOperation(Operation.INSERT)
                .setMapper(this::mapToObject)
                .build()
        )
        tableChangesHandler.addTableChange(
            TableChange.Builder<BsExportAdGroupShowConditionObject>()
                .setTable(ADGROUP_PAGE_TARGETS)
                .setOperation(Operation.DELETE)
                .setMapper(this::mapToObject)
                .build()
        )
    }

    private fun mapToObject(proceededChange: ProceededChange): BsExportAdGroupShowConditionObject {
        val adGroupId: Long = proceededChange.getPrimaryKey(ADGROUP_PAGE_TARGETS.PID)
        val debugInfo = extractDebugInfo(proceededChange)
        return BsExportAdGroupShowConditionObject(
            adGroupId,
            campaignId = null,
            AdGroupShowConditionType.PAGE_BLOCKS,
            debugInfo
        )
    }
}
