package ru.yandex.direct.ess.router.rules.bsexport.adgroup.showconditions

import org.springframework.stereotype.Component
import ru.yandex.direct.binlog.model.Operation
import ru.yandex.direct.dbschema.ppc.Tables.PHRASES
import ru.yandex.direct.dbschema.ppc.enums.PhrasesAdgroupType
import ru.yandex.direct.ess.logicobjects.bsexport.adgroup.AdGroupShowConditionType
import ru.yandex.direct.ess.logicobjects.bsexport.adgroup.BsExportAdGroupShowConditionObject
import ru.yandex.direct.ess.router.rules.bsexport.extractDebugInfo
import ru.yandex.direct.ess.router.utils.ProceededChange
import ru.yandex.direct.ess.router.utils.TableChange
import ru.yandex.direct.ess.router.utils.TableChangesHandler

@Component
class AdGroupShowConditionPerformanceFilter : AdGroupShowConditionFilter {
    override fun configure(tableChangesHandler: TableChangesHandler<BsExportAdGroupShowConditionObject>) {
        tableChangesHandler.addTableChange(
            TableChange.Builder<BsExportAdGroupShowConditionObject>()
                .setTable(PHRASES)
                .setOperation(Operation.INSERT)
                .setValuesFilter(this::filterChange)
                .setMapper(this::mapToObject)
                .build()
        )
    }

    private fun filterChange(proceededChange: ProceededChange): Boolean {
        val adGroupType: String = proceededChange.getBeforeOrAfter(PHRASES.ADGROUP_TYPE)
        return adGroupType == PhrasesAdgroupType.performance.literal
    }

    private fun mapToObject(proceededChange: ProceededChange): BsExportAdGroupShowConditionObject {
        val adGroupId: Long = proceededChange.getPrimaryKey(PHRASES.PID)
        val campaignId: Long = proceededChange.getBeforeOrAfter(PHRASES.CID)
        val debugInfo = extractDebugInfo(proceededChange)
        return BsExportAdGroupShowConditionObject(
            adGroupId,
            campaignId,
            AdGroupShowConditionType.PERFORMANCE,
            debugInfo
        )
    }
}
