package ru.yandex.direct.ess.router.rules.bsexport.adgroup.showconditions

import org.springframework.stereotype.Component
import ru.yandex.direct.binlog.model.Operation
import ru.yandex.direct.dbschema.ppc.Tables.PHRASES
import ru.yandex.direct.dbschema.ppc.Tables.CAMPAIGNS_INTERNAL
import ru.yandex.direct.ess.logicobjects.bsexport.adgroup.AdGroupShowConditionType
import ru.yandex.direct.ess.logicobjects.bsexport.adgroup.BsExportAdGroupShowConditionObject
import ru.yandex.direct.ess.router.rules.bsexport.extractDebugInfo
import ru.yandex.direct.ess.router.utils.ColumnsChangeType
import ru.yandex.direct.ess.router.utils.ProceededChange
import ru.yandex.direct.ess.router.utils.TableChange
import ru.yandex.direct.ess.router.utils.TableChangesHandler

@Component
class AdGroupShowConditionPlaceFilter : AdGroupShowConditionFilter {
    override fun configure(tableChangesHandler: TableChangesHandler<BsExportAdGroupShowConditionObject>) {
        tableChangesHandler.addTableChange(
            TableChange.Builder<BsExportAdGroupShowConditionObject>()
                .setTable(CAMPAIGNS_INTERNAL)
                .setOperation(Operation.UPDATE)
                .setColumns(ColumnsChangeType.ANY, listOf(CAMPAIGNS_INTERNAL.PLACE_ID))
                .setMapper(this::mapCampaignsToObject)
                .build()
        )
        tableChangesHandler.addTableChange(
            TableChange.Builder<BsExportAdGroupShowConditionObject>()
                .setTable(PHRASES)
                .setOperation(Operation.INSERT)
                .setMapper(this::mapPhrasesToObject)
                .build()
        )
    }

    private fun mapPhrasesToObject(proceededChange: ProceededChange): BsExportAdGroupShowConditionObject {
        val adGroupId: Long = proceededChange.getPrimaryKey(PHRASES.PID)
        val campaignId: Long = proceededChange.getBeforeOrAfter(PHRASES.CID)
        val debugInfo = extractDebugInfo(proceededChange)
        return BsExportAdGroupShowConditionObject(adGroupId, campaignId, AdGroupShowConditionType.PLACE, debugInfo)
    }

    private fun mapCampaignsToObject(proceededChange: ProceededChange): BsExportAdGroupShowConditionObject {
        val campaignId: Long = proceededChange.getPrimaryKey(CAMPAIGNS_INTERNAL.CID)
        val debugInfo = extractDebugInfo(proceededChange)
        return BsExportAdGroupShowConditionObject(null, campaignId, AdGroupShowConditionType.PLACE, debugInfo)
    }
}
