package ru.yandex.direct.ess.router.rules.bsexport.campaign;

import java.util.List;

import ru.yandex.direct.binlog.model.BinlogEvent;
import ru.yandex.direct.ess.config.bsexport.campaign.BsExportCampaignConfig;
import ru.yandex.direct.ess.logicobjects.bsexport.campaing.BsExportCampaignObject;
import ru.yandex.direct.ess.router.models.rule.AbstractRule;
import ru.yandex.direct.ess.router.models.rule.EssRule;
import ru.yandex.direct.ess.router.rules.bsexport.campaign.filter.BaseCampaignFilter;
import ru.yandex.direct.ess.router.utils.TableChangesHandler;

@EssRule(BsExportCampaignConfig.class)
public class BsExportCampaignRule extends AbstractRule<BsExportCampaignObject> {

    private final TableChangesHandler<BsExportCampaignObject> tableChangesHandler;

    public BsExportCampaignRule(List<BaseCampaignFilter> filters) {
        tableChangesHandler = new TableChangesHandler<>();
        filters.forEach(baseBannerResourceFilter -> baseBannerResourceFilter.init(tableChangesHandler));
    }

    @Override
    public List<BsExportCampaignObject> mapBinlogEvent(BinlogEvent binlogEvent) {
        return tableChangesHandler.processChanges(binlogEvent);
    }
}
