package ru.yandex.direct.ess.router.rules.bsexport.campaign.filter;

import java.util.Set;

import ru.yandex.direct.dbschema.ppc.enums.CampaignsType;
import ru.yandex.direct.ess.logicobjects.bsexport.campaing.BsExportCampaignObject;
import ru.yandex.direct.ess.logicobjects.bsexport.campaing.CampaignResourceType;
import ru.yandex.direct.ess.router.utils.ProceededChange;
import ru.yandex.direct.ess.router.utils.TableChangesHandler;

import static ru.yandex.direct.dbschema.ppc.Tables.CAMPAIGNS;

public abstract class BaseCampaignFilter {
    private static final Set<String> NOT_HANDLED_CAMPAIGNS_TYPE = Set.of(CampaignsType.mcb.getLiteral(),
            CampaignsType.geo.getLiteral());


    public abstract void init(TableChangesHandler<BsExportCampaignObject> tableChangesHandler);

    public abstract CampaignResourceType campaignResourceType();

    boolean isSuitableType(ProceededChange proceededChange) {
        String type = proceededChange.getBeforeOrAfter(CAMPAIGNS.TYPE);
        return !NOT_HANDLED_CAMPAIGNS_TYPE.contains(type);
    }

    void setSystemFields(ProceededChange proceededChange, BsExportCampaignObject.Builder objectBuilder) {
        objectBuilder.setReqid(proceededChange.getReqId())
                .setCampaignResourceType(campaignResourceType())
                .setMethod(proceededChange.getMethod())
                .setService(proceededChange.getService());
    }
}
