package ru.yandex.direct.ess.router.rules.bsexport.campaign.filter;

import org.springframework.stereotype.Component;

import ru.yandex.direct.binlog.model.Operation;
import ru.yandex.direct.ess.logicobjects.bsexport.campaing.BsExportCampaignObject;
import ru.yandex.direct.ess.logicobjects.bsexport.campaing.CampaignResourceType;
import ru.yandex.direct.ess.router.utils.ProceededChange;
import ru.yandex.direct.ess.router.utils.TableChange;
import ru.yandex.direct.ess.router.utils.TableChangesHandler;

import static ru.yandex.direct.dbschema.ppc.Tables.CAMPAIGNS;

@Component
public class CampaignDeleteFilter extends BaseCampaignFilter {

    @Override
    public void init(TableChangesHandler<BsExportCampaignObject> tableChangesHandler) {
        tableChangesHandler.addTableChange(new TableChange.Builder<BsExportCampaignObject>()
                .setTable(CAMPAIGNS)
                .setValuesFilter(this::isSuitableType)
                .setOperation(Operation.DELETE)
                .setMapper(this::mapToObject)
                .build());
    }

    @Override
    public CampaignResourceType campaignResourceType() {
        return CampaignResourceType.CAMPAIGN_DELETE;
    }

    private BsExportCampaignObject mapToObject(ProceededChange proceededChange) {
        var objectBuilder =
                new BsExportCampaignObject.Builder()
                        .setCid(proceededChange.getPrimaryKey(CAMPAIGNS.CID))
                        .setOrderId(proceededChange.getBefore(CAMPAIGNS.ORDER_ID));
        setSystemFields(proceededChange, objectBuilder);
        return objectBuilder.build();
    }
}
