package ru.yandex.direct.ess.router.rules.bsexport.campaign.filter

import org.springframework.stereotype.Component
import ru.yandex.direct.binlog.model.Operation
import ru.yandex.direct.dbschema.ppc.Tables.CAMP_METRIKA_COUNTERS
import ru.yandex.direct.ess.logicobjects.bsexport.campaing.BsExportCampaignObject
import ru.yandex.direct.ess.logicobjects.bsexport.campaing.CampaignResourceType
import ru.yandex.direct.ess.router.utils.ProceededChange
import ru.yandex.direct.ess.router.utils.TableChange
import ru.yandex.direct.ess.router.utils.TableChangesHandler

@Component
class CampaignMetrikaCounterIdsFilter : BaseCampaignFilter() {
    override fun campaignResourceType() = CampaignResourceType.METRIKA_COUNTER_IDS

    override fun init(tableChangesHandler: TableChangesHandler<BsExportCampaignObject>) {
        tableChangesHandler.addTableChange(TableChange.Builder<BsExportCampaignObject>()
            .setTable(CAMP_METRIKA_COUNTERS)
            .setOperation(Operation.INSERT)
            .setMapper(this::mapToCampaignObject)
            .build())

        tableChangesHandler.addTableChange(TableChange.Builder<BsExportCampaignObject>()
            .setTable(CAMP_METRIKA_COUNTERS)
            .setOperation(Operation.UPDATE)
            .setColumn(CAMP_METRIKA_COUNTERS.METRIKA_COUNTERS)
            .setMapper(this::mapToCampaignObject)
            .build())

        tableChangesHandler.addTableChange(TableChange.Builder<BsExportCampaignObject>()
            .setTable(CAMP_METRIKA_COUNTERS)
            .setOperation(Operation.DELETE)
            .setMapper(this::mapToCampaignObject)
            .build())
    }

    private fun mapToCampaignObject(proceededChange: ProceededChange): BsExportCampaignObject {
        val objectBuilder = BsExportCampaignObject.Builder()
            .setCid(proceededChange.getPrimaryKey(CAMP_METRIKA_COUNTERS.CID))
        setSystemFields(proceededChange, objectBuilder)
        return objectBuilder.build()
    }
}
