package ru.yandex.direct.ess.router.rules.bsexport.campaign.filter;

import org.springframework.stereotype.Component;

import ru.yandex.direct.binlog.model.Operation;
import ru.yandex.direct.ess.logicobjects.bsexport.campaing.BsExportCampaignObject;
import ru.yandex.direct.ess.logicobjects.bsexport.campaing.CampaignResourceType;
import ru.yandex.direct.ess.router.utils.ProceededChange;
import ru.yandex.direct.ess.router.utils.TableChange;
import ru.yandex.direct.ess.router.utils.TableChangesHandler;

import static ru.yandex.direct.dbschema.ppc.Tables.CAMP_OPTIONS;

@Component
public class CampaignMinusPhrasesFilter extends BaseCampaignFilter {

    @Override
    public void init(TableChangesHandler<BsExportCampaignObject> tableChangesHandler) {
        tableChangesHandler.addTableChange(new TableChange.Builder<BsExportCampaignObject>()
                .setTable(CAMP_OPTIONS)
                .setOperation(Operation.INSERT)
                .setMapper(this::mapToCampOptionsObject)
                .build());

        tableChangesHandler.addTableChange(new TableChange.Builder<BsExportCampaignObject>()
                .setTable(CAMP_OPTIONS)
                .setOperation(Operation.UPDATE)
                .setColumn(CAMP_OPTIONS.MINUS_WORDS)
                .setMapper(this::mapToCampOptionsObject)
                .build());
    }

    @Override
    public CampaignResourceType campaignResourceType() {
        return CampaignResourceType.CAMPAIGN_MINUS_PHRASES;
    }

    private BsExportCampaignObject mapToCampOptionsObject(ProceededChange proceededChange) {
        var objectBuilder = new BsExportCampaignObject.Builder()
                .setCid(proceededChange.getPrimaryKey(CAMP_OPTIONS.CID));
        setSystemFields(proceededChange, objectBuilder);
        return objectBuilder.build();
    }


}
