package ru.yandex.direct.ess.router.rules.bsexport.campaign.filter

import org.jooq.Field
import org.springframework.stereotype.Component
import ru.yandex.direct.binlog.model.Operation
import ru.yandex.direct.dbschema.ppc.Tables
import ru.yandex.direct.ess.logicobjects.bsexport.campaing.BsExportCampaignObject
import ru.yandex.direct.ess.logicobjects.bsexport.campaing.CampaignResourceType
import ru.yandex.direct.ess.router.utils.ProceededChange
import ru.yandex.direct.ess.router.utils.TableChange
import ru.yandex.direct.ess.router.utils.TableChangesHandler

@Component
class CampaignMobileMarkFilter : BaseCampaignFilter() {
    override fun campaignResourceType() = CampaignResourceType.MOBILE_GOALS

    override fun init(tableChangesHandler: TableChangesHandler<BsExportCampaignObject>) {
        tableChangesHandler.addTableChange(TableChange.Builder<BsExportCampaignObject>()
            .setTable(Tables.CAMPAIGNS)
            .setOperation(Operation.INSERT)
            .setValuesFilter { isSuitableType(it) }
            .setMapper { mapToExportObject(it, Tables.CAMPAIGNS.CID) }
            .build())

        tableChangesHandler.addTableChange(TableChange.Builder<BsExportCampaignObject>()
            .setTable(Tables.CAMPAIGNS)
            .setOperation(Operation.UPDATE)
            .setValuesFilter { isSuitableType(it) }
            .setColumn(Tables.CAMPAIGNS.STRATEGY_DATA)
            .setMapper { mapToExportObject(it, Tables.CAMPAIGNS.CID) }
            .build())

        tableChangesHandler.addTableChange(TableChange.Builder<BsExportCampaignObject>()
            .setTable(Tables.CAMP_OPTIONS)
            .setOperation(Operation.INSERT)
            .setMapper { mapToExportObject(it, Tables.CAMP_OPTIONS.CID) }
            .build())

        tableChangesHandler.addTableChange(TableChange.Builder<BsExportCampaignObject>()
            .setTable(Tables.CAMP_OPTIONS)
            .setOperation(Operation.UPDATE)
            .setColumn(Tables.CAMP_OPTIONS.MEANINGFUL_GOALS)
            .setMapper { mapToExportObject(it, Tables.CAMP_OPTIONS.CID) }
            .build())
    }

    private fun mapToExportObject(proceededChange: ProceededChange, pkField: Field<*>): BsExportCampaignObject? {
        val objectBuilder = BsExportCampaignObject.Builder()
            .setCid(proceededChange.getPrimaryKey(pkField))
        setSystemFields(proceededChange, objectBuilder)
        return objectBuilder.build()
    }
}
