package ru.yandex.direct.ess.router.rules.bsexport.campaign.filter;

import java.util.List;

import org.springframework.stereotype.Component;

import ru.yandex.direct.binlog.model.Operation;
import ru.yandex.direct.ess.logicobjects.bsexport.campaing.BsExportCampaignObject;
import ru.yandex.direct.ess.logicobjects.bsexport.campaing.CampaignResourceType;
import ru.yandex.direct.ess.router.utils.ColumnsChangeType;
import ru.yandex.direct.ess.router.utils.ProceededChange;
import ru.yandex.direct.ess.router.utils.TableChange;
import ru.yandex.direct.ess.router.utils.TableChangesHandler;

import static ru.yandex.direct.dbschema.ppc.Tables.CAMPAIGNS;

@Component
public class CampaignStrategyFilter extends BaseCampaignFilter {

    @Override
    public void init(TableChangesHandler<BsExportCampaignObject> tableChangesHandler) {
        tableChangesHandler.addTableChange(new TableChange.Builder<BsExportCampaignObject>()
                .setTable(CAMPAIGNS)
                .setOperation(Operation.INSERT)
                .setValuesFilter(this::isSuitableType)
                .setMapper(this::mapToCampaignObject)
                .build());

        tableChangesHandler.addTableChange(
                new TableChange.Builder<BsExportCampaignObject>()
                        .setTable(CAMPAIGNS)
                        .setOperation(Operation.UPDATE)
                        .setValuesFilter(this::isSuitableType)
                        .setColumns(ColumnsChangeType.ANY,
                                List.of(CAMPAIGNS.PLATFORM, CAMPAIGNS.STRATEGY_ID))
                        .setMapper(this::mapToCampaignObject)
                        .build());
    }

    @Override
    public CampaignResourceType campaignResourceType() {
        return CampaignResourceType.CAMPAIGN_STRATEGY;
    }

    private BsExportCampaignObject mapToCampaignObject(ProceededChange proceededChange) {
        var objectBuilder = new BsExportCampaignObject.Builder()
                .setCid(proceededChange.getPrimaryKey(CAMPAIGNS.CID));
        setSystemFields(proceededChange, objectBuilder);
        return objectBuilder.build();
    }
}
