package ru.yandex.direct.ess.router.rules.bsexport.campaign.filter;

import org.springframework.stereotype.Component;

import ru.yandex.direct.binlog.model.Operation;
import ru.yandex.direct.ess.logicobjects.bsexport.campaing.BsExportCampaignObject;
import ru.yandex.direct.ess.logicobjects.bsexport.campaing.CampaignResourceType;
import ru.yandex.direct.ess.router.utils.ProceededChange;
import ru.yandex.direct.ess.router.utils.TableChange;
import ru.yandex.direct.ess.router.utils.TableChangesHandler;

import static ru.yandex.direct.dbschema.ppc.Tables.WIDGET_PARTNER_CAMPAIGNS;

@Component
public class CampaignWidgetPartnerIdFilter extends BaseCampaignFilter {
    @Override
    public void init(TableChangesHandler<BsExportCampaignObject> tableChangesHandler) {
        tableChangesHandler.addTableChange(
                new TableChange.Builder<BsExportCampaignObject>()
                        .setTable(WIDGET_PARTNER_CAMPAIGNS)
                        .setOperation(Operation.INSERT)
                        .setMapper(this::mapToCampaignObject)
                        .build());

        tableChangesHandler.addTableChange(
                new TableChange.Builder<BsExportCampaignObject>()
                        .setTable(WIDGET_PARTNER_CAMPAIGNS)
                        .setOperation(Operation.UPDATE)
                        .setColumn(WIDGET_PARTNER_CAMPAIGNS.WIDGET_PARTNER_ID)
                        .setMapper(this::mapToCampaignObject)
                        .build());
    }

    @Override
    public CampaignResourceType campaignResourceType() {
        return CampaignResourceType.WIDGET_PARTNER_ID;
    }

    private BsExportCampaignObject mapToCampaignObject(ProceededChange proceededChange) {
        var objectBuilder = new BsExportCampaignObject.Builder()
                .setCid(proceededChange.getPrimaryKey(WIDGET_PARTNER_CAMPAIGNS.CID));
        setSystemFields(proceededChange, objectBuilder);
        return objectBuilder.build();
    }
}
