package ru.yandex.direct.ess.router.rules.bsexport.campaign.filter

import org.jooq.Field
import org.springframework.stereotype.Component
import ru.yandex.direct.binlog.model.Operation
import ru.yandex.direct.dbschema.ppc.Tables
import ru.yandex.direct.ess.logicobjects.bsexport.campaing.BsExportCampaignObject
import ru.yandex.direct.ess.logicobjects.bsexport.campaing.CampaignResourceType
import ru.yandex.direct.ess.router.utils.ColumnsChangeType
import ru.yandex.direct.ess.router.utils.ProceededChange
import ru.yandex.direct.ess.router.utils.TableChange
import ru.yandex.direct.ess.router.utils.TableChangesHandler

@Component
class CampaignWithBrandLiftFilter : BaseCampaignFilter() {
    override fun init(tableChangesHandler: TableChangesHandler<BsExportCampaignObject>) {
        tableChangesHandler.addTableChange(
            TableChange.Builder<BsExportCampaignObject>()
            .setTable(Tables.CAMP_OPTIONS)
            .setOperation(Operation.INSERT)
            .setMapper { mapToExportObject(it, Tables.CAMP_OPTIONS.CID) }
            .build()
        )

        tableChangesHandler.addTableChange(
            TableChange.Builder<BsExportCampaignObject>()
            .setTable(Tables.CAMP_OPTIONS)
            .setOperation(Operation.UPDATE)
            .setColumns(ColumnsChangeType.ANY, listOf(Tables.CAMP_OPTIONS.BRAND_SURVEY_ID,
                Tables.CAMP_OPTIONS.IS_SEARCH_LIFT_ENABLED,
                Tables.CAMP_OPTIONS.IS_CPM_GLOBAL_AB_SEGMENT)
            )
            .setMapper { mapToExportObject(it, Tables.CAMP_OPTIONS.CID) }
            .build()
        )
    }

    private fun mapToExportObject(proceededChange: ProceededChange, pkField: Field<*>): BsExportCampaignObject? {
        val objectBuilder = BsExportCampaignObject.Builder()
            .setCid(proceededChange.getPrimaryKey(pkField))
        setSystemFields(proceededChange, objectBuilder)
        return objectBuilder.build()
    }

    override fun campaignResourceType(): CampaignResourceType {
        return CampaignResourceType.IS_CPM_GLOBAL_AB_SEGMENT
    }
}
