package ru.yandex.direct.ess.router.rules.bsexport.campaign.filter

import org.jooq.Field
import org.springframework.stereotype.Component
import ru.yandex.direct.binlog.model.Operation
import ru.yandex.direct.core.entity.campaign.model.CampaignOpts
import ru.yandex.direct.dbschema.ppc.Tables
import ru.yandex.direct.dbschema.ppc.enums.CampaignsType
import ru.yandex.direct.dbschema.ppc.tables.Campaigns
import ru.yandex.direct.ess.logicobjects.bsexport.campaing.BsExportCampaignObject
import ru.yandex.direct.ess.logicobjects.bsexport.campaing.CampaignResourceType
import ru.yandex.direct.ess.router.utils.ProceededChange
import ru.yandex.direct.ess.router.utils.TableChange
import ru.yandex.direct.ess.router.utils.TableChangesHandler

@Component
class CampaignWithWwManagedOrderFlagFilter : BaseCampaignFilter() {
    companion object {
        val ALLOWED_CAMPAIGN_TYPES = setOf(
            CampaignsType.performance.literal,
        )
    }

    override fun init(tableChangesHandler: TableChangesHandler<BsExportCampaignObject>) {
        tableChangesHandler.addTableChange(TableChange.Builder<BsExportCampaignObject>()
            .setTable(Tables.CAMPAIGNS)
            .setOperation(Operation.INSERT)
            .setValuesFilter { isWwManagedOrderFlagChanged(it) }
            .setMapper { mapToExportObject(it, Tables.CAMPAIGNS.CID) }
            .build()
        )

        tableChangesHandler.addTableChange(TableChange.Builder<BsExportCampaignObject>()
            .setTable(Tables.CAMPAIGNS)
            .setOperation(Operation.UPDATE)
            .setColumn(Tables.CAMPAIGNS.OPTS)
            .setValuesFilter { isWwManagedOrderFlagChanged(it) }
            .setMapper { mapToExportObject(it, Tables.CAMPAIGNS.CID) }
            .build()
        )
    }

    private fun mapToExportObject(proceededChange: ProceededChange, pkField: Field<*>): BsExportCampaignObject? {
        val objectBuilder = BsExportCampaignObject.Builder()
            .setCid(proceededChange.getPrimaryKey(pkField))
        setSystemFields(proceededChange, objectBuilder)
        return objectBuilder.build()
    }

    override fun campaignResourceType(): CampaignResourceType {
        return CampaignResourceType.WW_MANAGED_ORDER_FLAG
    }

    private fun isWwManagedOrderFlagChanged(change: ProceededChange): Boolean {
        val campaignType = change.getBeforeOrAfter<String, CampaignsType>(Campaigns.CAMPAIGNS.TYPE)
        val campaignTypeIsAllowed = campaignType != null && ALLOWED_CAMPAIGN_TYPES.contains(campaignType)
        val before = getIsWwManagedOrder(change.getBefore(Campaigns.CAMPAIGNS.OPTS))
        val after = getIsWwManagedOrder(change.getAfter(Campaigns.CAMPAIGNS.OPTS))
        return campaignTypeIsAllowed && before != after
    }

    private fun getIsWwManagedOrder(opts: String?): Boolean {
        return opts != null && opts.contains(CampaignOpts.IS_WW_MANAGED_ORDER.typedValue)
    }
}
