package ru.yandex.direct.ess.router.rules.bsexport.campaign.filter;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.binlog.model.Operation;
import ru.yandex.direct.ess.logicobjects.bsexport.campaing.BsExportCampaignObject;
import ru.yandex.direct.ess.logicobjects.bsexport.campaing.CampaignResourceType;
import ru.yandex.direct.ess.router.utils.ProceededChange;
import ru.yandex.direct.ess.router.utils.TableChange;
import ru.yandex.direct.ess.router.utils.TableChangesHandler;

import static ru.yandex.direct.dbschema.ppc.Tables.CAMPAIGNS_INTERNAL;

@Component
@ParametersAreNonnullByDefault
public class InternalCampaignRotationGoalIdFilter extends BaseCampaignFilter {

    @Override
    public void init(TableChangesHandler<BsExportCampaignObject> tableChangesHandler) {
        tableChangesHandler.addTableChange(new TableChange.Builder<BsExportCampaignObject>()
                .setTable(CAMPAIGNS_INTERNAL)
                .setOperation(Operation.INSERT)
                .setMapper(this::mapToInternalCampaignObject)
                .build());

        tableChangesHandler.addTableChange(new TableChange.Builder<BsExportCampaignObject>()
                .setTable(CAMPAIGNS_INTERNAL)
                .setOperation(Operation.UPDATE)
                .setColumn(CAMPAIGNS_INTERNAL.ROTATION_GOAL_ID)
                .setMapper(this::mapToInternalCampaignObject)
                .build());
    }

    @Override
    public CampaignResourceType campaignResourceType() {
        return CampaignResourceType.INTERNAL_CAMPAIGN_ROTATION_GOAL_ID;
    }

    private BsExportCampaignObject mapToInternalCampaignObject(ProceededChange proceededChange) {
        var objectBuilder = new BsExportCampaignObject.Builder()
                .setCid(proceededChange.getPrimaryKey(CAMPAIGNS_INTERNAL.CID));
        setSystemFields(proceededChange, objectBuilder);
        return objectBuilder.build();
    }

}
