package ru.yandex.direct.ess.router.rules.bsexport.campaign.filter;

import java.util.List;

import org.springframework.stereotype.Component;

import ru.yandex.direct.binlog.model.Operation;
import ru.yandex.direct.ess.logicobjects.bsexport.campaing.BsExportCampaignObject;
import ru.yandex.direct.ess.logicobjects.bsexport.campaing.CampaignResourceType;
import ru.yandex.direct.ess.logicobjects.bsexport.campaing.ClientAdditionalTargetingsInfo;
import ru.yandex.direct.ess.router.utils.ProceededChange;
import ru.yandex.direct.ess.router.utils.TableChange;
import ru.yandex.direct.ess.router.utils.TableChangesHandler;

import static ru.yandex.direct.dbschema.ppc.Tables.CAMPAIGNS;
import static ru.yandex.direct.dbschema.ppc.Tables.CAMPAIGNS_CPM_YNDX_FRONTPAGE;
import static ru.yandex.direct.dbschema.ppc.Tables.CAMPAIGNS_INTERNAL;
import static ru.yandex.direct.dbschema.ppc.Tables.CAMP_ADDITIONAL_TARGETINGS;
import static ru.yandex.direct.dbschema.ppc.Tables.CAMP_OPTIONS;
import static ru.yandex.direct.dbschema.ppc.Tables.CLIENT_ADDITIONAL_TARGETINGS;
import static ru.yandex.direct.dbschema.ppc.Tables.RETARGETING_CONDITIONS;
import static ru.yandex.direct.ess.router.utils.ColumnsChangeType.ANY;

@Component
public class ShowConditionsFilter extends BaseCampaignFilter {
    @Override
    public CampaignResourceType campaignResourceType() {
        return CampaignResourceType.SHOW_CONDITIONS;
    }

    @Override
    public void init(TableChangesHandler<BsExportCampaignObject> tableChangesHandler) {
        tableChangesHandler.addTableChange(new TableChange.Builder<BsExportCampaignObject>()
                .setTable(CAMPAIGNS)
                .setOperation(Operation.INSERT)
                .setValuesFilter(this::isSuitableType)
                .setMapper(this::mapCampaignToObject)
                .build());

        tableChangesHandler.addTableChange(
                new TableChange.Builder<BsExportCampaignObject>()
                        .setTable(CAMPAIGNS)
                        .setOperation(Operation.UPDATE)
                        .setValuesFilter(this::isSuitableType)
                        .setColumns(ANY, List.of(
                                CAMPAIGNS.DISABLED_IPS,
                                CAMPAIGNS.DISABLED_SSP,
                                CAMPAIGNS.DISABLED_VIDEO_PLACEMENTS,
                                CAMPAIGNS.DONT_SHOW,
                                CAMPAIGNS.PLATFORM,
                                CAMPAIGNS.STRATEGY_DATA,
                                CAMPAIGNS.TIME_TARGET,
                                CAMPAIGNS.FINISH_TIME,
                                CAMPAIGNS.AUTOBUDGET,
                                CAMPAIGNS.DAY_BUDGET,
                                CAMPAIGNS.STRATEGY_NAME,
                                CAMPAIGNS.OPTS,
                                CAMPAIGNS.BRANDSAFETY_RET_COND_ID,
                                CAMPAIGNS.RF,
                                CAMPAIGNS.RF_RESET))
                        .setMapper(this::mapCampaignToObject)
                        .build());

        tableChangesHandler.addTableChange(new TableChange.Builder<BsExportCampaignObject>()
                .setTable(CAMP_OPTIONS)
                .setOperation(Operation.INSERT)
                .setMapper(this::mapCampOptionsToObject)
                .build());

        tableChangesHandler.addTableChange(
                new TableChange.Builder<BsExportCampaignObject>()
                        .setTable(CAMP_OPTIONS)
                        .setOperation(Operation.UPDATE)
                        .setColumns(ANY, List.of(CAMP_OPTIONS.ALLOWED_PAGE_IDS, CAMP_OPTIONS.DISALLOWED_PAGE_IDS))
                        .setMapper(this::mapCampOptionsToObject)
                        .build());

        tableChangesHandler.addTableChange(new TableChange.Builder<BsExportCampaignObject>()
                .setTable(CAMPAIGNS_CPM_YNDX_FRONTPAGE)
                .setOperation(Operation.INSERT)
                .setMapper(this::mapCpmYndxToObject)
                .build());

        tableChangesHandler.addTableChange(
                new TableChange.Builder<BsExportCampaignObject>()
                        .setTable(CAMPAIGNS_CPM_YNDX_FRONTPAGE)
                        .setOperation(Operation.UPDATE)
                        .setColumn(CAMPAIGNS_CPM_YNDX_FRONTPAGE.ALLOWED_FRONTPAGE_TYPES)
                        .setMapper(this::mapCpmYndxToObject)
                        .build());


        tableChangesHandler.addTableChange(new TableChange.Builder<BsExportCampaignObject>()
                .setTable(CAMPAIGNS_INTERNAL)
                .setOperation(Operation.INSERT)
                .setMapper(this::mapCampaignInternalToObject)
                .build());

        tableChangesHandler.addTableChange(
                new TableChange.Builder<BsExportCampaignObject>()
                        .setTable(CAMPAIGNS_INTERNAL)
                        .setOperation(Operation.UPDATE)
                        .setColumn(CAMPAIGNS_INTERNAL.PAGE_IDS)
                        .setMapper(this::mapCampaignInternalToObject)
                        .build());

        tableChangesHandler.addTableChange(new TableChange.Builder<BsExportCampaignObject>()
                .setTable(RETARGETING_CONDITIONS)
                .setOperation(Operation.INSERT)
                .setMapper(this::mapRetargetingToObject)
                .build());

        tableChangesHandler.addTableChange(
                new TableChange.Builder<BsExportCampaignObject>()
                        .setTable(RETARGETING_CONDITIONS)
                        .setOperation(Operation.UPDATE)
                        .setColumn(RETARGETING_CONDITIONS.CONDITION_JSON)
                        .setMapper(this::mapRetargetingToObject)
                        .build());

        tableChangesHandler.addTableChange(new TableChange.Builder<BsExportCampaignObject>()
                .setTable(CAMP_ADDITIONAL_TARGETINGS)
                .setOperation(Operation.INSERT)
                .setMapper(this::mapCampAdditionalTargetingToObject)
                .build());

        tableChangesHandler.addTableChange(new TableChange.Builder<BsExportCampaignObject>()
                .setTable(CAMP_ADDITIONAL_TARGETINGS)
                .setOperation(Operation.UPDATE)
                .setColumn(CAMP_ADDITIONAL_TARGETINGS.DATA)
                .setMapper(this::mapCampAdditionalTargetingToObject)
                .build());

        tableChangesHandler.addTableChange(new TableChange.Builder<BsExportCampaignObject>()
                .setTable(CAMP_ADDITIONAL_TARGETINGS)
                .setOperation(Operation.DELETE)
                .setMapper(this::mapCampAdditionalTargetingToObject)
                .build());

        tableChangesHandler.addTableChange(new TableChange.Builder<BsExportCampaignObject>()
                .setTable(CLIENT_ADDITIONAL_TARGETINGS)
                .setOperation(Operation.INSERT)
                .setMapper(this::mapClientAdditionalTargetingToObject)
                .build());

        tableChangesHandler.addTableChange(new TableChange.Builder<BsExportCampaignObject>()
                .setTable(CLIENT_ADDITIONAL_TARGETINGS)
                .setOperation(Operation.UPDATE)
                .setColumn(CLIENT_ADDITIONAL_TARGETINGS.DATA)
                .setMapper(this::mapClientAdditionalTargetingToObject)
                .build());

        tableChangesHandler.addTableChange(new TableChange.Builder<BsExportCampaignObject>()
                .setTable(CLIENT_ADDITIONAL_TARGETINGS)
                .setOperation(Operation.DELETE)
                .setMapper(this::mapClientAdditionalTargetingToObject)
                .build());
    }

    private BsExportCampaignObject mapCampaignToObject(ProceededChange proceededChange) {
        var objectBuilder = new BsExportCampaignObject.Builder()
                .setCid(proceededChange.getPrimaryKey(CAMPAIGNS.CID));
        setSystemFields(proceededChange, objectBuilder);
        return objectBuilder.build();
    }

    private BsExportCampaignObject mapCampOptionsToObject(ProceededChange proceededChange) {
        var objectBuilder = new BsExportCampaignObject.Builder()
                .setCid(proceededChange.getPrimaryKey(CAMP_OPTIONS.CID));
        setSystemFields(proceededChange, objectBuilder);
        return objectBuilder.build();
    }

    private BsExportCampaignObject mapCpmYndxToObject(ProceededChange proceededChange) {
        var objectBuilder = new BsExportCampaignObject.Builder()
                .setCid(proceededChange.getPrimaryKey(CAMPAIGNS_CPM_YNDX_FRONTPAGE.CID));
        setSystemFields(proceededChange, objectBuilder);
        return objectBuilder.build();
    }

    private BsExportCampaignObject mapCampaignInternalToObject(ProceededChange proceededChange) {
        var objectBuilder = new BsExportCampaignObject.Builder()
                .setCid(proceededChange.getPrimaryKey(CAMPAIGNS_INTERNAL.CID));
        setSystemFields(proceededChange, objectBuilder);
        return objectBuilder.build();
    }

    private BsExportCampaignObject mapRetargetingToObject(ProceededChange proceededChange) {
        var objectBuilder = new BsExportCampaignObject.Builder()
                .setBrandsafetyRetCondId(proceededChange.getPrimaryKey(RETARGETING_CONDITIONS.RET_COND_ID));
        setSystemFields(proceededChange, objectBuilder);
        return objectBuilder.build();
    }

    private BsExportCampaignObject mapCampAdditionalTargetingToObject(ProceededChange proceededChange) {
        var objectBuilder = new BsExportCampaignObject.Builder()
                .setCid(proceededChange.getBeforeOrAfter(CAMP_ADDITIONAL_TARGETINGS.CID));
        setSystemFields(proceededChange, objectBuilder);
        return objectBuilder.build();
    }

    private BsExportCampaignObject mapClientAdditionalTargetingToObject(ProceededChange proceededChange) {
        Long clientId = proceededChange.getBeforeOrAfter(CLIENT_ADDITIONAL_TARGETINGS.CLIENT_ID);
        var objectBuilder = new BsExportCampaignObject.Builder()
                .setAdditionalInfo(new ClientAdditionalTargetingsInfo(clientId));
        setSystemFields(proceededChange, objectBuilder);
        return objectBuilder.build();
    }
}
