package ru.yandex.direct.ess.router.rules.bsexport.meaningfulgoals;

import java.util.List;

import ru.yandex.direct.binlog.model.BinlogEvent;
import ru.yandex.direct.ess.config.bsexport.meaningfulgoals.BsExportMeaningfulGoalsConfig;
import ru.yandex.direct.ess.logicobjects.bsexport.meaningfulgoals.BsExportMeaningfulGoalsObject;
import ru.yandex.direct.ess.router.models.rule.AbstractRule;
import ru.yandex.direct.ess.router.models.rule.EssRule;
import ru.yandex.direct.ess.router.utils.ProceededChange;
import ru.yandex.direct.ess.router.utils.TableChange;
import ru.yandex.direct.ess.router.utils.TableChangesHandler;

import static ru.yandex.direct.binlog.model.Operation.INSERT;
import static ru.yandex.direct.binlog.model.Operation.UPDATE;
import static ru.yandex.direct.dbschema.ppc.tables.CampOptions.CAMP_OPTIONS;
import static ru.yandex.direct.ess.router.utils.ColumnsChangeType.ANY;

@EssRule(BsExportMeaningfulGoalsConfig.class)
public class BsExportMeaningfulGoalRule extends AbstractRule<BsExportMeaningfulGoalsObject> {
    private final TableChangesHandler<BsExportMeaningfulGoalsObject> tableChangesHandler = new TableChangesHandler<>();

    public BsExportMeaningfulGoalRule() {
        tableChangesHandler.addTableChange(
                new TableChange.Builder<BsExportMeaningfulGoalsObject>()
                        .setTable(CAMP_OPTIONS)
                        .setOperation(UPDATE)
                        .setColumns(ANY, List.of(CAMP_OPTIONS.MEANINGFUL_GOALS))
                        .setMapper(BsExportMeaningfulGoalRule::mapMultipliersChangeToObject)
                        .build());

        tableChangesHandler.addTableChange(
                new TableChange.Builder<BsExportMeaningfulGoalsObject>()
                        .setTable(CAMP_OPTIONS)
                        .setOperation(INSERT)
                        .setColumns(ANY, List.of(CAMP_OPTIONS.MEANINGFUL_GOALS))
                        .setMapper(BsExportMeaningfulGoalRule::mapMultipliersChangeToObject)
                        .build());
    }

    private static BsExportMeaningfulGoalsObject mapMultipliersChangeToObject(ProceededChange change) {
        return new BsExportMeaningfulGoalsObject(change.getPrimaryKey(CAMP_OPTIONS.CID),
                change.getAfter(CAMP_OPTIONS.MEANINGFUL_GOALS));
    }

    @Override
    public List<BsExportMeaningfulGoalsObject> mapBinlogEvent(BinlogEvent binlogEvent) {
        return tableChangesHandler.processChanges(binlogEvent);
    }
}
