package ru.yandex.direct.ess.router.rules.bsexport.metrikacounters

import ru.yandex.direct.binlog.model.BinlogEvent
import ru.yandex.direct.binlog.model.Operation.DELETE
import ru.yandex.direct.binlog.model.Operation.INSERT
import ru.yandex.direct.dbschema.ppc.Tables.METRIKA_COUNTERS
import ru.yandex.direct.ess.config.bsexport.metrikacounters.BsExportMetrikaCountersConfig
import ru.yandex.direct.ess.logicobjects.bsexport.metrikacounters.BsExportMetrikaCountersObject
import ru.yandex.direct.ess.router.models.rule.AbstractRule
import ru.yandex.direct.ess.router.models.rule.EssRule
import ru.yandex.direct.ess.router.utils.ProceededChange
import ru.yandex.direct.ess.router.utils.TableChange
import ru.yandex.direct.ess.router.utils.TableChangesHandler

@EssRule(BsExportMetrikaCountersConfig::class)
class BsExportMetrikaCountersRule : AbstractRule<BsExportMetrikaCountersObject>() {

    private val tableChangesHandler = TableChangesHandler<BsExportMetrikaCountersObject>().also {
        it.addTableChange(
            TableChange.Builder<BsExportMetrikaCountersObject>()
                .setTable(METRIKA_COUNTERS)
                .setOperation(INSERT)
                .setMapper(this::mapMetrikaCounterChangeToObject)
                .build()
        )
        it.addTableChange(
            TableChange.Builder<BsExportMetrikaCountersObject>()
                .setTable(METRIKA_COUNTERS)
                .setOperation(DELETE)
                .setMapper(this::mapMetrikaCounterChangeToObject)
                .build()
        )
    }

    private fun mapMetrikaCounterChangeToObject(change: ProceededChange): BsExportMetrikaCountersObject {
        return BsExportMetrikaCountersObject(
            campaignId = change.getPrimaryKey(METRIKA_COUNTERS.CID),
        )
    }

    override fun mapBinlogEvent(binlogEvent: BinlogEvent): List<BsExportMetrikaCountersObject> =
        tableChangesHandler.processChanges(binlogEvent)

}
