package ru.yandex.direct.ess.router.rules.bsexport.mobilegoals;

import java.util.List;

import ru.yandex.direct.binlog.model.BinlogEvent;
import ru.yandex.direct.ess.config.bsexport.mobilegoals.BsExportMobileGoalsExternalTrackerConfig;
import ru.yandex.direct.ess.logicobjects.bsexport.mobilegoals.BsExportMobileGoalsExternalTrackerObject;
import ru.yandex.direct.ess.router.models.rule.AbstractRule;
import ru.yandex.direct.ess.router.models.rule.EssRule;
import ru.yandex.direct.ess.router.utils.ProceededChange;
import ru.yandex.direct.ess.router.utils.TableChange;
import ru.yandex.direct.ess.router.utils.TableChangesHandler;

import static ru.yandex.direct.binlog.model.Operation.DELETE;
import static ru.yandex.direct.binlog.model.Operation.INSERT;
import static ru.yandex.direct.binlog.model.Operation.UPDATE;
import static ru.yandex.direct.dbschema.ppc.Tables.MOBILE_APP_GOALS_EXTERNAL_TRACKER;

@EssRule(BsExportMobileGoalsExternalTrackerConfig.class)
public class BsExportMobileGoalsExternalTrackerRule extends AbstractRule<BsExportMobileGoalsExternalTrackerObject> {

    private final TableChangesHandler<BsExportMobileGoalsExternalTrackerObject> tableChangesHandler;

    public BsExportMobileGoalsExternalTrackerRule() {
        tableChangesHandler = new TableChangesHandler<>();
        tableChangesHandler.addTableChange(
                new TableChange.Builder<BsExportMobileGoalsExternalTrackerObject>()
                        .setTable(MOBILE_APP_GOALS_EXTERNAL_TRACKER)
                        .setOperation(UPDATE)
                        .setMapper(this::mapToObject)
                        .build()
        );
        tableChangesHandler.addTableChange(
                new TableChange.Builder<BsExportMobileGoalsExternalTrackerObject>()
                        .setTable(MOBILE_APP_GOALS_EXTERNAL_TRACKER)
                        .setOperation(INSERT)
                        .setMapper(this::mapToObject)
                        .build()
        );
        tableChangesHandler.addTableChange(
                new TableChange.Builder<BsExportMobileGoalsExternalTrackerObject>()
                        .setTable(MOBILE_APP_GOALS_EXTERNAL_TRACKER)
                        .setOperation(DELETE)
                        .setMapper(this::mapToDeletedObject)
                        .build()
        );
    }

    @Override
    public List<BsExportMobileGoalsExternalTrackerObject> mapBinlogEvent(BinlogEvent binlogEvent) {
        return tableChangesHandler.processChanges(binlogEvent);
    }

    private BsExportMobileGoalsExternalTrackerObject mapToObject(ProceededChange proceededChange) {
        return mapToObjectInternal(proceededChange);
    }

    private BsExportMobileGoalsExternalTrackerObject mapToDeletedObject(ProceededChange proceededChange) {
        var object = mapToObjectInternal(proceededChange);
        object.setDeleted(true);
        return object;
    }

    private BsExportMobileGoalsExternalTrackerObject mapToObjectInternal(ProceededChange proceededChange) {
        Long goalId = proceededChange.getPrimaryKey(MOBILE_APP_GOALS_EXTERNAL_TRACKER.GOAL_ID);
        BsExportMobileGoalsExternalTrackerObject object = new BsExportMobileGoalsExternalTrackerObject(goalId);
        object.setReqid(proceededChange.getReqId());
        object.setService(proceededChange.getService());
        object.setMethod(proceededChange.getMethod());
        return object;
    }

}
