package ru.yandex.direct.ess.router.rules.bsexport.resources;

import java.util.List;

import ru.yandex.direct.binlog.model.BinlogEvent;
import ru.yandex.direct.ess.config.bsexport.resources.BsExportBannerResourcesConfig;
import ru.yandex.direct.ess.logicobjects.bsexport.resources.BsExportBannerResourcesObject;
import ru.yandex.direct.ess.router.models.rule.AbstractRule;
import ru.yandex.direct.ess.router.models.rule.EssRule;
import ru.yandex.direct.ess.router.rules.bsexport.resources.filter.IBannerResourceFilter;
import ru.yandex.direct.ess.router.utils.TableChangesHandler;

@EssRule(BsExportBannerResourcesConfig.class)
public class BsExportBannerResourcesRule extends AbstractRule<BsExportBannerResourcesObject> {

    private final TableChangesHandler<BsExportBannerResourcesObject> tableChangesHandler;

    public BsExportBannerResourcesRule(List<IBannerResourceFilter> baseBannerResourceFilters) {
        tableChangesHandler = new TableChangesHandler<>();
        baseBannerResourceFilters.forEach(baseBannerResourceFilter -> baseBannerResourceFilter.init(tableChangesHandler));
    }

    @Override
    public List<BsExportBannerResourcesObject> mapBinlogEvent(BinlogEvent binlogEvent) {
        return tableChangesHandler.processChanges(binlogEvent);
    }
}
