package ru.yandex.direct.ess.router.rules.bsexport.resources.filter;

import org.jooq.Table;
import org.springframework.stereotype.Component;

import ru.yandex.direct.dbschema.ppc.enums.BannerButtonsStatusmoderate;
import ru.yandex.direct.ess.logicobjects.bsexport.resources.BannerResourceType;
import ru.yandex.direct.ess.logicobjects.bsexport.resources.BsExportBannerResourcesObject;
import ru.yandex.direct.ess.router.utils.ProceededChange;

import static ru.yandex.direct.dbschema.ppc.Tables.BANNER_BUTTONS;

@Component
public class BannerButtonsFilter extends BaseBannerResourceFilter {
    @Override
    public BannerResourceType bannerResourceType() {
        return BannerResourceType.BANNER_BUTTON;
    }

    @Override
    protected Table<?> getResourceTable() {
        return BANNER_BUTTONS;
    }

    @Override
    protected boolean checkStatusModerate(ProceededChange proceededChange) {
        if (!proceededChange.afterContains(BANNER_BUTTONS.STATUS_MODERATE)) {
            return true;
        }
        var statusModerate = proceededChange.getAfter(BANNER_BUTTONS.STATUS_MODERATE);
        return BannerButtonsStatusmoderate.Yes.getLiteral().equals(statusModerate) || BannerButtonsStatusmoderate.No.getLiteral().equals(statusModerate);

    }

    @Override
    protected BsExportBannerResourcesObject mapToObject(ProceededChange proceededChange) {
        return new BsExportBannerResourcesObject.Builder()
                .setBid(proceededChange.getPrimaryKey(BANNER_BUTTONS.BID))
                .setResourceType(bannerResourceType())
                .build();
    }
}
