package ru.yandex.direct.ess.router.rules.bsexport.resources.filter;

import org.springframework.stereotype.Component;

import ru.yandex.direct.binlog.model.Operation;
import ru.yandex.direct.ess.logicobjects.bsexport.resources.BsExportBannerResourcesObject;
import ru.yandex.direct.ess.router.utils.ProceededChange;
import ru.yandex.direct.ess.router.utils.TableChange;
import ru.yandex.direct.ess.router.utils.TableChangesHandler;

import static ru.yandex.direct.dbschema.ppc.Tables.BANNERS;
import static ru.yandex.direct.ess.logicobjects.bsexport.resources.BannerResourceType.BANNER_DELETE;

@Component
public class BannerDeleteFilter implements IBannerResourceFilter {
    @Override
    public void init(TableChangesHandler<BsExportBannerResourcesObject> tableChangesHandler) {
        tableChangesHandler.addTableChange(
                new TableChange.Builder<BsExportBannerResourcesObject>()
                        .setTable(BANNERS)
                        .setOperation(Operation.DELETE)
                        .setMapper(this::mapToObject)
                        .build()
        );
    }

    private BsExportBannerResourcesObject mapToObject(ProceededChange proceededChange) {
        return new BsExportBannerResourcesObject.Builder()
                .setBid(proceededChange.getPrimaryKey(BANNERS.BID))
                .setPid(proceededChange.getBefore(BANNERS.PID))
                .setCid(proceededChange.getBefore(BANNERS.CID))
                .setBannerId(proceededChange.getBefore(BANNERS.BANNER_ID))
                .setResourceType(BANNER_DELETE)
                .build();
    }

}
