package ru.yandex.direct.ess.router.rules.bsexport.resources.filter;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.Table;
import org.springframework.stereotype.Component;

import ru.yandex.direct.ess.logicobjects.bsexport.resources.BannerResourceType;
import ru.yandex.direct.ess.logicobjects.bsexport.resources.BsExportBannerResourcesObject;
import ru.yandex.direct.ess.router.utils.ProceededChange;

import static ru.yandex.direct.dbschema.ppc.Tables.BANNER_DISPLAY_HREF_TEXTS;

@Component
@ParametersAreNonnullByDefault
public class BannerGreenUrlTextsFilter extends BaseBannerResourceFilter {

    @Override
    public BannerResourceType bannerResourceType() {
        return BannerResourceType.BANNER_GREEN_URL_TEXTS;
    }

    @Override
    protected Table<?> getResourceTable() {
        return BANNER_DISPLAY_HREF_TEXTS;
    }

    @Override
    protected boolean checkStatusModerate(ProceededChange proceededChange) {
        return true;
    }

    @Override
    protected BsExportBannerResourcesObject mapToObject(ProceededChange proceededChange) {
        return new BsExportBannerResourcesObject.Builder()
                .setBid(proceededChange.getPrimaryKey(BANNER_DISPLAY_HREF_TEXTS.BID))
                .setResourceType(bannerResourceType())
                .build();
    }

}
