package ru.yandex.direct.ess.router.rules.bsexport.resources.filter;

import java.util.List;

import org.jooq.Named;
import org.springframework.stereotype.Component;

import ru.yandex.direct.ess.logicobjects.bsexport.resources.BannerResourceType;

import static ru.yandex.direct.dbschema.ppc.Tables.BANNERS;

@Component
public class BannerHrefFilter extends BaseBannerFilter {

    @Override
    List<Named> getObservableColumns() {
        return List.of(BANNERS.HREF, BANNERS.DOMAIN, BANNERS.LANGUAGE);
    }

    @Override
    public BannerResourceType bannerResourceType() {
        return BannerResourceType.BANNER_HREF;
    }
}
