package ru.yandex.direct.ess.router.rules.bsexport.resources.filter;

import org.springframework.stereotype.Component;

import ru.yandex.direct.binlog.model.Operation;
import ru.yandex.direct.ess.logicobjects.bsexport.resources.BannerResourceType;
import ru.yandex.direct.ess.logicobjects.bsexport.resources.BsExportBannerResourcesObject;
import ru.yandex.direct.ess.router.utils.ProceededChange;
import ru.yandex.direct.ess.router.utils.TableChange;
import ru.yandex.direct.ess.router.utils.TableChangesHandler;

import static ru.yandex.direct.dbschema.ppc.Tables.BANNER_IMAGES;
import static ru.yandex.direct.ess.router.rules.bsexport.resources.filter.BaseBannerResourceFilter.addDebugInfo;

/**
 * Фильтр для картиночных копий баннеров.
 * Отправляет ресурсы родительского баннера на копию при ее появлении
 * в таблице {@link ru.yandex.direct.dbschema.ppc.tables.BannerImages}.
 */
@Component
public class BannerImageFilter implements IBannerResourceFilter {
    @Override
    public void init(TableChangesHandler<BsExportBannerResourcesObject> tableChangesHandler) {
        tableChangesHandler.addTableChange(
                new TableChange.Builder<BsExportBannerResourcesObject>()
                        .setTable(BANNER_IMAGES)
                        .setOperation(Operation.INSERT)
                        .setMapper(this::mapBannerImageChangeToObject)
                        .build()
        );
    }

    private BsExportBannerResourcesObject mapBannerImageChangeToObject(ProceededChange proceededChange) {
        var object = new BsExportBannerResourcesObject.Builder()
                .setBid(proceededChange.getAfter(BANNER_IMAGES.BID))
                // Добавление картинки в BANNER_IMAGES требует не переотправки какого-то конкретного ресурса для
                // оригинального баннера, но разовой отправки всех ресурсов для созданной картиночной копии баннера
                .setResourceType(BannerResourceType.ALL)
                .setImageBannerExclusive(true)
                .build();
        addDebugInfo(object, proceededChange);
        return object;
    }
}
