package ru.yandex.direct.ess.router.rules.bsexport.resources.filter;

import org.jooq.Table;
import org.springframework.stereotype.Component;

import ru.yandex.direct.dbschema.ppc.enums.BannerLogosStatusmoderate;
import ru.yandex.direct.ess.logicobjects.bsexport.resources.BannerResourceType;
import ru.yandex.direct.ess.logicobjects.bsexport.resources.BsExportBannerResourcesObject;
import ru.yandex.direct.ess.router.utils.ProceededChange;

import static ru.yandex.direct.dbschema.ppc.Tables.BANNER_LOGOS;

@Component
public class BannerLogosFilter extends BaseBannerResourceFilter {
    @Override
    public BannerResourceType bannerResourceType() {
        return BannerResourceType.BANNER_LOGO;
    }

    @Override
    protected Table getResourceTable() {
        return BANNER_LOGOS;
    }

    @Override
    protected boolean checkStatusModerate(ProceededChange proceededChange) {
        if (!proceededChange.afterContains(BANNER_LOGOS.STATUS_MODERATE)) {
            return true;
        }
        var statusModerate = proceededChange.getAfter(BANNER_LOGOS.STATUS_MODERATE);
        return BannerLogosStatusmoderate.Yes.getLiteral().equals(statusModerate) || BannerLogosStatusmoderate.No.getLiteral().equals(statusModerate);

    }

    @Override
    protected BsExportBannerResourcesObject mapToObject(ProceededChange proceededChange) {
        return new BsExportBannerResourcesObject.Builder()
                .setBid(proceededChange.getPrimaryKey(BANNER_LOGOS.BID))
                .setResourceType(bannerResourceType())
                .build();
    }
}
