package ru.yandex.direct.ess.router.rules.bsexport.resources.filter;

import org.springframework.stereotype.Component;

import ru.yandex.direct.ess.logicobjects.bsexport.resources.BannerResourceType;
import ru.yandex.direct.ess.logicobjects.bsexport.resources.BsExportBannerResourcesObject;
import ru.yandex.direct.ess.router.utils.ProceededChange;
import ru.yandex.direct.ess.router.utils.TableChange;
import ru.yandex.direct.ess.router.utils.TableChangesHandler;

import static ru.yandex.direct.binlog.model.Operation.INSERT;
import static ru.yandex.direct.binlog.model.Operation.UPDATE;
import static ru.yandex.direct.dbschema.ppc.Tables.BANNERS_MOBILE_CONTENT;
import static ru.yandex.direct.ess.router.rules.bsexport.resources.filter.BaseBannerResourceFilter.addDebugInfo;

// Фильтр для банеров с привязанным banners_mobile_content
@Component
public class BannerMobileContentDataFilter implements IBannerResourceFilter {
    @Override
    public void init(TableChangesHandler<BsExportBannerResourcesObject> tableChangesHandler) {
        tableChangesHandler.addTableChange(
                new TableChange.Builder<BsExportBannerResourcesObject>()
                        .setTable(BANNERS_MOBILE_CONTENT)
                        .setOperation(INSERT)
                        .setMapper(this::mapBannerMobileContentObject)
                        .build());
        tableChangesHandler.addTableChange(
                new TableChange.Builder<BsExportBannerResourcesObject>()
                        .setTable(BANNERS_MOBILE_CONTENT)
                        .setOperation(UPDATE)
                        .setColumn(BANNERS_MOBILE_CONTENT.IMPRESSION_URL)
                        .setMapper(this::mapBannerMobileContentObject)
                        .build());
    }

    private BannerResourceType bannerResourceType() {
        return BannerResourceType.BANNER_MOBILE_CONTENT_DATA;
    }

    private BsExportBannerResourcesObject mapBannerMobileContentObject(ProceededChange change) {
        var object = new BsExportBannerResourcesObject.Builder()
                .setBid(change.getPrimaryKey(BANNERS_MOBILE_CONTENT.BID))
                .setResourceType(bannerResourceType())
                .build();
        addDebugInfo(object, change);
        return object;
    }
}
