package ru.yandex.direct.ess.router.rules.bsexport.resources.filter

import org.springframework.stereotype.Component
import ru.yandex.direct.binlog.model.Operation
import ru.yandex.direct.dbschema.ppc.Tables.BANNER_MULTICARDS
import ru.yandex.direct.dbschema.ppc.Tables.BANNER_MULTICARD_SETS
import ru.yandex.direct.dbschema.ppc.enums.BannerMulticardSetsStatusmoderate
import ru.yandex.direct.dbschema.ppc.tables.BannerMulticardSets
import ru.yandex.direct.ess.common.utils.TablesEnum
import ru.yandex.direct.ess.logicobjects.bsexport.resources.BannerResourceType
import ru.yandex.direct.ess.logicobjects.bsexport.resources.BsExportBannerResourcesObject
import ru.yandex.direct.ess.router.utils.ProceededChange
import ru.yandex.direct.ess.router.utils.TableChange
import ru.yandex.direct.ess.router.utils.TableChangesHandler

@Component
class BannerMulticardSetFilter : BaseBannerResourceFilter() {

    override fun bannerResourceType() = BannerResourceType.BANNER_MULTICARD

    override fun getResourceTable(): BannerMulticardSets = BANNER_MULTICARD_SETS

    override fun addAdditionalChanges(tableChangesHandler: TableChangesHandler<BsExportBannerResourcesObject>) {
        tableChangesHandler.addTableChange(
            TableChange.Builder<BsExportBannerResourcesObject>()
                .setTable(BANNER_MULTICARDS)
                .setOperation(Operation.UPDATE)
                .setColumn(BANNER_MULTICARDS.ORDER_NUM)
                .setMapper(this::mapToObjectInternal)
                .build()
        )
    }

    override fun checkStatusModerate(proceededChange: ProceededChange): Boolean {
        if (!proceededChange.afterContains(BANNER_MULTICARD_SETS.STATUS_MODERATE)) {
            return true
        }

        val statusModerate: String =
            proceededChange.getAfter(BANNER_MULTICARD_SETS.STATUS_MODERATE)
        return BannerMulticardSetsStatusmoderate.Yes.literal.equals(statusModerate)
                || BannerMulticardSetsStatusmoderate.No.literal.equals(statusModerate)
    }

    override fun mapToObject(proceededChange: ProceededChange): BsExportBannerResourcesObject {
        if (proceededChange.tableIs(BANNER_MULTICARD_SETS)) {
            val bid: Long = proceededChange.getPrimaryKey(BANNER_MULTICARD_SETS.BID)
            return BsExportBannerResourcesObject.Builder()
                .setBid(bid)
                .setResourceType(bannerResourceType())
                .build()
        } else if (proceededChange.tableIs(BANNER_MULTICARDS)) {
            val multicardId: Long = proceededChange.getPrimaryKey(BANNER_MULTICARDS.MULTICARD_ID)
            return BsExportBannerResourcesObject.Builder()
                .setAdditionalId(multicardId)
                .setAdditionalTable(TablesEnum.BANNER_MULTICARDS)
                .setResourceType(bannerResourceType())
                .build()
        } else {
            throw IllegalStateException("Unexpected table in proceededChange: $proceededChange")
        }
    }
}
