package ru.yandex.direct.ess.router.rules.bsexport.resources.filter;

import org.jooq.Table;
import org.springframework.stereotype.Component;

import ru.yandex.direct.dbschema.ppc.enums.BannerNamesStatusmoderate;
import ru.yandex.direct.ess.logicobjects.bsexport.resources.BannerResourceType;
import ru.yandex.direct.ess.logicobjects.bsexport.resources.BsExportBannerResourcesObject;
import ru.yandex.direct.ess.router.utils.ProceededChange;

import static ru.yandex.direct.dbschema.ppc.Tables.BANNER_NAMES;

@Component
public class BannerNameFilter extends BaseBannerResourceFilter {
    @Override
    public BannerResourceType bannerResourceType() {
        return BannerResourceType.BANNER_NAME;
    }

    @Override
    protected Table<?> getResourceTable() {
        return BANNER_NAMES;
    }

    @Override
    protected boolean checkStatusModerate(ProceededChange proceededChange) {
        if (!proceededChange.afterContains(BANNER_NAMES.STATUS_MODERATE)) {
            return true;
        }
        var statusModerate = proceededChange.getAfter(BANNER_NAMES.STATUS_MODERATE);
        return BannerNamesStatusmoderate.Yes.getLiteral().equals(statusModerate)
                || BannerNamesStatusmoderate.No.getLiteral().equals(statusModerate);

    }

    @Override
    protected BsExportBannerResourcesObject mapToObject(ProceededChange proceededChange) {
        return new BsExportBannerResourcesObject.Builder()
                .setBid(proceededChange.getPrimaryKey(BANNER_NAMES.BID))
                .setResourceType(bannerResourceType())
                .build();
    }
}
