package ru.yandex.direct.ess.router.rules.bsexport.resources.filter;

import java.util.List;

import org.springframework.stereotype.Component;

import ru.yandex.direct.binlog.model.Operation;
import ru.yandex.direct.dbschema.ppc.enums.BannersStatusmoderate;
import ru.yandex.direct.ess.common.utils.TablesEnum;
import ru.yandex.direct.ess.logicobjects.bsexport.resources.BannerResourceType;
import ru.yandex.direct.ess.logicobjects.bsexport.resources.BsExportBannerResourcesObject;
import ru.yandex.direct.ess.router.utils.ProceededChange;
import ru.yandex.direct.ess.router.utils.TableChange;
import ru.yandex.direct.ess.router.utils.TableChangesHandler;

import static ru.yandex.direct.dbschema.ppc.Tables.BANNERS;
import static ru.yandex.direct.dbschema.ppc.Tables.BANNER_PERMALINKS;
import static ru.yandex.direct.dbschema.ppc.Tables.ORGANIZATIONS;
import static ru.yandex.direct.ess.router.rules.bsexport.resources.filter.BaseBannerResourceFilter.addDebugInfo;
import static ru.yandex.direct.ess.router.utils.ColumnsChangeType.ANY;

@Component
public class BannerPermalinksFilter implements IBannerResourceFilter {

    @Override
    public void init(TableChangesHandler<BsExportBannerResourcesObject> tableChangesHandler) {
        addBannerChanges(tableChangesHandler);
        addOrganizationsChanges(tableChangesHandler);
        addBannerPermalinksChanges(tableChangesHandler);
    }

    private void addBannerChanges(TableChangesHandler<BsExportBannerResourcesObject> tableChangesHandler) {
        tableChangesHandler.addTableChange(
                new TableChange.Builder<BsExportBannerResourcesObject>()
                        .setTable(BANNERS)
                        .setOperation(Operation.UPDATE)
                        .setColumn(BANNERS.STATUS_MODERATE)
                        .setValuesFilter(this::isBannerModerate)
                        .setMapper(this::mapToBannerObject)
                        .build());
    }

    private void addOrganizationsChanges(TableChangesHandler<BsExportBannerResourcesObject> tableChangesHandler) {
        tableChangesHandler.addTableChange(
                new TableChange.Builder<BsExportBannerResourcesObject>()
                        .setTable(ORGANIZATIONS)
                        .setOperation(Operation.UPDATE)
                        .setColumn(ORGANIZATIONS.STATUS_PUBLISH)
                        .setMapper(this::mapToOrganizationObject)
                        .build());
    }

    private void addBannerPermalinksChanges(TableChangesHandler<BsExportBannerResourcesObject> tableChangesHandler) {
        tableChangesHandler.addTableChange(
                new TableChange.Builder<BsExportBannerResourcesObject>()
                        .setTable(BANNER_PERMALINKS)
                        .setOperation(Operation.INSERT)
                        .setMapper(this::mapToBannerPermalinksObject)
                        .build());
        tableChangesHandler.addTableChange(
                new TableChange.Builder<BsExportBannerResourcesObject>()
                        .setTable(BANNER_PERMALINKS)
                        .setOperation(Operation.DELETE)
                        .setMapper(this::mapToBannerPermalinksObject)
                        .build());
        tableChangesHandler.addTableChange(
                new TableChange.Builder<BsExportBannerResourcesObject>()
                        .setTable(BANNER_PERMALINKS)
                        .setOperation(Operation.UPDATE)
                        .setColumns(ANY, List.of(
                                BANNER_PERMALINKS.PERMALINK_ASSIGN_TYPE,
                                BANNER_PERMALINKS.CHAIN_ID,
                                BANNER_PERMALINKS.PREFER_VCARD_OVER_PERMALINK))
                        .setMapper(this::mapToBannerPermalinksObject)
                        .build());
    }

    private BannerResourceType bannerResourceType() {
        return BannerResourceType.BANNER_PERMALINKS;
    }

    protected BsExportBannerResourcesObject mapToBannerPermalinksObject(ProceededChange proceededChange) {
        return new BsExportBannerResourcesObject.Builder()
                .setBid(proceededChange.getPrimaryKey(BANNER_PERMALINKS.BID))
                .setResourceType(bannerResourceType())
                .build();
    }

    private boolean isBannerModerate(ProceededChange change) {
        return BannersStatusmoderate.Yes.getLiteral().equals(change.getAfter(BANNERS.STATUS_MODERATE));
    }

    private BsExportBannerResourcesObject mapToOrganizationObject(ProceededChange change) {
        var object = new BsExportBannerResourcesObject.Builder()
                .setAdditionalTable(TablesEnum.ORGANIZATIONS)
                .setAdditionalId(change.getPrimaryKey(ORGANIZATIONS.PERMALINK_ID))
                .setResourceType(bannerResourceType())
                .build();
        addDebugInfo(object, change);
        return object;
    }

    private BsExportBannerResourcesObject mapToBannerObject(ProceededChange change) {
        var object = new BsExportBannerResourcesObject.Builder()
                .setBid(change.getPrimaryKey(BANNERS.BID))
                .setPid(change.getAfter(BANNERS.PID))
                .setCid(change.getAfter(BANNERS.CID))
                .setResourceType(bannerResourceType())
                .build();
        addDebugInfo(object, change);
        return object;
    }
}
