package ru.yandex.direct.ess.router.rules.bsexport.resources.filter

import org.springframework.stereotype.Component
import ru.yandex.direct.binlog.model.Operation
import ru.yandex.direct.dbschema.ppc.Tables.BANNERS
import ru.yandex.direct.dbschema.ppc.Tables.CAMPAIGN_PROMOACTIONS
import ru.yandex.direct.dbschema.ppc.Tables.PROMOACTIONS
import ru.yandex.direct.dbschema.ppc.enums.PromoactionsStatusmoderate
import ru.yandex.direct.dbschema.ppc.tables.Promoactions
import ru.yandex.direct.ess.common.utils.TablesEnum
import ru.yandex.direct.ess.logicobjects.bsexport.resources.BannerResourceType
import ru.yandex.direct.ess.logicobjects.bsexport.resources.BsExportBannerResourcesObject
import ru.yandex.direct.ess.router.utils.ProceededChange
import ru.yandex.direct.ess.router.utils.TableChange
import ru.yandex.direct.ess.router.utils.TableChangesHandler

@Component
class BannerPromoExtensionsFilter : BaseBannerResourceFilter() {

    override fun bannerResourceType() = BannerResourceType.BANNER_PROMO_EXTENSION

    override fun getResourceTable(): Promoactions = PROMOACTIONS

    /**
     * Поскольку новые и удаляемые промоакции ни к чему не привязаны, реагируем только на обновление
     */
    override fun addBaseTableChanges(tableChangesHandler: TableChangesHandler<BsExportBannerResourcesObject>) {
        tableChangesHandler.addTableChange(
            TableChange.Builder<BsExportBannerResourcesObject>()
                .setTable(getResourceTable())
                .setOperation(Operation.UPDATE)
                .setValuesFilter(this::checkStatusModerate)
                .setMapper(this::mapToObjectInternal)
                .build()
        )
    }

    override fun addAdditionalChanges(tableChangesHandler: TableChangesHandler<BsExportBannerResourcesObject>) {
        tableChangesHandler.addTableChange(
            TableChange.Builder<BsExportBannerResourcesObject>()
                .setTable(CAMPAIGN_PROMOACTIONS)
                .setOperation(Operation.INSERT)
                .setMapper(this::mapCampaignPromoactionChangeToObject)
                .build()
        )
        tableChangesHandler.addTableChange(
            TableChange.Builder<BsExportBannerResourcesObject>()
                .setTable(CAMPAIGN_PROMOACTIONS)
                .setOperation(Operation.UPDATE)
                .setMapper(this::mapCampaignPromoactionChangeToObject)
                .build()
        )
        tableChangesHandler.addTableChange(
            TableChange.Builder<BsExportBannerResourcesObject>()
                .setTable(CAMPAIGN_PROMOACTIONS)
                .setOperation(Operation.DELETE)
                .setMapper(this::mapCampaignPromoactionChangeToObject)
                .build()
        )

        tableChangesHandler.addTableChange(
            TableChange.Builder<BsExportBannerResourcesObject>()
                .setTable(BANNERS)
                .setOperation(Operation.INSERT)
                .setMapper(this::mapBannersInsertToObject)
                .build()
        )
    }

    override fun checkStatusModerate(proceededChange: ProceededChange): Boolean {
        if (!proceededChange.afterContains(PROMOACTIONS.STATUS_MODERATE)) {
            return true
        }

        val statusModerate: String =
            proceededChange.getAfter(PROMOACTIONS.STATUS_MODERATE)
        return PromoactionsStatusmoderate.Yes.literal.equals(statusModerate)
            || PromoactionsStatusmoderate.No.literal.equals(statusModerate)
    }

    override fun mapToObject(proceededChange: ProceededChange): BsExportBannerResourcesObject {
        val promoExtensionId: Long = proceededChange.getLongPrimaryKey(PROMOACTIONS.ID)
        return BsExportBannerResourcesObject.Builder()
            .setAdditionalId(promoExtensionId)
            .setAdditionalTable(TablesEnum.PROMOACTIONS)
            .setResourceType(bannerResourceType())
            .build()
    }

    private fun mapCampaignPromoactionChangeToObject(proceededChange: ProceededChange): BsExportBannerResourcesObject {
        val cid: Long = proceededChange.getPrimaryKey(CAMPAIGN_PROMOACTIONS.CID)
        val result = BsExportBannerResourcesObject.Builder()
            .setAdditionalId(cid)
            .setAdditionalTable(TablesEnum.CAMPAIGN_PROMOACTIONS)
            .setResourceType(bannerResourceType())
            .build()
        addDebugInfo(result, proceededChange)
        return result
    }

    private fun mapBannersInsertToObject(proceededChange: ProceededChange): BsExportBannerResourcesObject {
        val bid: Long = proceededChange.getPrimaryKey(BANNERS.BID)
        val result = BsExportBannerResourcesObject.Builder()
            .setAdditionalId(bid)
            .setAdditionalTable(TablesEnum.BANNERS)
            .setResourceType(bannerResourceType())
            .build()
        addDebugInfo(result, proceededChange)
        return result
    }
}
