package ru.yandex.direct.ess.router.rules.bsexport.resources.filter

import org.jooq.Table
import org.springframework.stereotype.Component
import ru.yandex.direct.dbschema.ppc.Tables.BANNERS_PERFORMANCE
import ru.yandex.direct.ess.logicobjects.bsexport.resources.BannerResourceType
import ru.yandex.direct.ess.router.utils.ProceededChange
import ru.yandex.direct.ess.logicobjects.bsexport.resources.BannerResourceType.BANNER_SHOW_TITLE_AND_BODY
import ru.yandex.direct.ess.logicobjects.bsexport.resources.BsExportBannerResourcesObject
import ru.yandex.direct.ess.logicobjects.bsexport.resources.BsExportBannerResourcesObject.Builder

@Component
class BannerShowTitleAndBodyFilter : BaseBannerResourceFilter() {
    override fun bannerResourceType(): BannerResourceType {
        return BANNER_SHOW_TITLE_AND_BODY
    }

    override fun getResourceTable(): Table<*> {
        return BANNERS_PERFORMANCE
    }

    override fun checkStatusModerate(proceededChange: ProceededChange): Boolean {
        return true
    }

    override fun observableColumns() = listOf(BANNERS_PERFORMANCE.SHOW_TITLE_AND_BODY)

    override fun mapToObject(proceededChange: ProceededChange): BsExportBannerResourcesObject {
        return Builder()
                .setBid(proceededChange.getLongBeforeOrAfter(BANNERS_PERFORMANCE.BID))
                .setResourceType(bannerResourceType())
                .build()
    }
}
