package ru.yandex.direct.ess.router.rules.bsexport.resources.filter;

import java.util.List;

import org.jooq.Named;

import ru.yandex.direct.ess.logicobjects.bsexport.resources.BannerResourceType;
import ru.yandex.direct.ess.router.utils.ProceededChange;

import static ru.yandex.direct.dbschema.ppc.Tables.BANNERS;

/**
 * Не компонента, потому что временно остановили отправку
 */
public class BannerStopFilter extends BaseBannerFilter {

    @Override
    List<Named> getObservableColumns() {
        return List.of(BANNERS.STATUS_SHOW, BANNERS.STATUS_POST_MODERATE);
    }

    @Override
    public BannerResourceType bannerResourceType() {
        return BannerResourceType.BANNER_STOP;
    }

    /**
     * Отправляем Stop баннера независимо от статуса модерации
     */
    @Override
    boolean checkStatusModerate(ProceededChange proceededChange) {
        return true;
    }
}
