package ru.yandex.direct.ess.router.rules.bsexport.resources.filter;

import org.jooq.Table;

import ru.yandex.direct.binlog.model.Operation;
import ru.yandex.direct.dbschema.ppc.enums.BannerTurbolandingsStatusmoderate;
import ru.yandex.direct.ess.logicobjects.bsexport.resources.BannerResourceType;
import ru.yandex.direct.ess.logicobjects.bsexport.resources.BsExportBannerResourcesObject;
import ru.yandex.direct.ess.router.utils.ProceededChange;
import ru.yandex.direct.ess.router.utils.TableChange;
import ru.yandex.direct.ess.router.utils.TableChangesHandler;

import static ru.yandex.direct.dbschema.ppc.Tables.BANNER_TURBOLANDINGS;
import static ru.yandex.direct.dbschema.ppc.Tables.BANNER_TURBOLANDING_PARAMS;
import static ru.yandex.direct.ess.logicobjects.bsexport.resources.BannerResourceType.BANNER_TURBOLANDING;

/**
 * Не компонента, потому что временно остановили отправку
 */
public class BannerTurboLandingsFilter extends BaseBannerResourceFilter {

    @Override
    public BannerResourceType bannerResourceType() {
        return BANNER_TURBOLANDING;
    }

    @Override
    public void addAdditionalChanges(TableChangesHandler<BsExportBannerResourcesObject> tableChangesHandler) {
        tableChangesHandler.addTableChange(
                new TableChange.Builder<BsExportBannerResourcesObject>()
                        .setTable(BANNER_TURBOLANDING_PARAMS)
                        .setOperation(Operation.INSERT)
                        .setMapper(this::mapToObjectInternal)
                        .build());
        tableChangesHandler.addTableChange(
                new TableChange.Builder<BsExportBannerResourcesObject>()
                        .setTable(BANNER_TURBOLANDING_PARAMS)
                        .setOperation(Operation.UPDATE)
                        .setMapper(this::mapToObjectInternal)
                        .build());
        // при удалении параметров сам ресурс удалять не надо
        tableChangesHandler.addTableChange(
                new TableChange.Builder<BsExportBannerResourcesObject>()
                        .setTable(BANNER_TURBOLANDING_PARAMS)
                        .setOperation(Operation.DELETE)
                        .setMapper(this::mapToObjectInternal)
                        .build());
    }

    @Override
    protected Table<?> getResourceTable() {
        return BANNER_TURBOLANDINGS;
    }

    @Override
    protected boolean checkStatusModerate(ProceededChange proceededChange) {
        if (!proceededChange.afterContains(BANNER_TURBOLANDINGS.STATUS_MODERATE)) {
            return true;
        }
        var statusModerate = proceededChange.getAfter(BANNER_TURBOLANDINGS.STATUS_MODERATE);
        return BannerTurbolandingsStatusmoderate.Yes.getLiteral().equals(statusModerate) || BannerTurbolandingsStatusmoderate.No.getLiteral().equals(statusModerate);
    }

    @Override
    protected BsExportBannerResourcesObject mapToObject(ProceededChange proceededChange) {
        long bid = proceededChange.tableIs(BANNER_TURBOLANDINGS) ?
                proceededChange.getPrimaryKey(BANNER_TURBOLANDINGS.BID) :
                proceededChange.getPrimaryKey(BANNER_TURBOLANDING_PARAMS.BID);
        return new BsExportBannerResourcesObject.Builder()
                .setBid(bid)
                .setResourceType(bannerResourceType())
                .build();
    }
}
