package ru.yandex.direct.ess.router.rules.bsexport.resources.filter;

import java.util.List;
import java.util.Objects;

import org.jooq.Named;

import ru.yandex.direct.dbschema.ppc.enums.BannersPhoneflag;
import ru.yandex.direct.ess.logicobjects.bsexport.resources.BannerResourceType;
import ru.yandex.direct.ess.router.utils.ProceededChange;

import static ru.yandex.direct.dbschema.ppc.Tables.BANNERS;

/**
 * Не компонента, потому что временно остановили отправку
 */
public class BannerVcardFilter extends BaseBannerFilter {

    @Override
    List<Named> getObservableColumns() {
        return List.of(BANNERS.VCARD_ID, BANNERS.PHONEFLAG);
    }

    @Override
    public BannerResourceType bannerResourceType() {
        return BannerResourceType.BANNER_VCARD;
    }


    /**
     * У визитки в таблице banners отдельный статус модерации, поэтому смотрим на него
     */
    @Override
    protected boolean checkStatusModerate(ProceededChange proceededChange) {
        if (!proceededChange.afterContains(BANNERS.PHONEFLAG)) {
            return true;
        }
        // если визитка удаляется, то статус модерации не важен
        if (proceededChange.afterContains(BANNERS.VCARD_ID) && Objects.isNull(proceededChange.getAfter(BANNERS.VCARD_ID))) {
            return true;
        }
        var vcardStatusModerate = proceededChange.getAfter(BANNERS.PHONEFLAG);
        return BannersPhoneflag.Yes.getLiteral().equals(vcardStatusModerate)
                || BannersPhoneflag.No.getLiteral().equals(vcardStatusModerate);
    }
}
