package ru.yandex.direct.ess.router.rules.bsexport.resources.filter

import org.springframework.stereotype.Component
import ru.yandex.direct.binlog.model.Operation
import ru.yandex.direct.dbschema.ppc.Tables.BANNER_PUBLISHER
import ru.yandex.direct.dbschema.ppc.Tables.CAMP_METRIKA_COUNTERS
import ru.yandex.direct.dbschema.ppc.tables.BannerPublisher
import ru.yandex.direct.ess.common.utils.TablesEnum
import ru.yandex.direct.ess.logicobjects.bsexport.resources.BannerResourceType
import ru.yandex.direct.ess.logicobjects.bsexport.resources.BsExportBannerResourcesObject
import ru.yandex.direct.ess.router.utils.ProceededChange
import ru.yandex.direct.ess.router.utils.TableChange
import ru.yandex.direct.ess.router.utils.TableChangesHandler

@Component
class BannerZenSubscribeFilter : BaseBannerResourceFilter() {

    override fun bannerResourceType() = BannerResourceType.BANNER_ZEN_SUBSCRIBE

    override fun getResourceTable(): BannerPublisher = BANNER_PUBLISHER

    override fun checkStatusModerate(change: ProceededChange): Boolean {
        return true
   }

    override fun addAdditionalChanges(tableChangesHandler: TableChangesHandler<BsExportBannerResourcesObject>) {
        tableChangesHandler.addTableChange(
            TableChange.Builder<BsExportBannerResourcesObject>()
                .setTable(CAMP_METRIKA_COUNTERS)
                .setOperation(Operation.INSERT)
                .setMapper(this::mapCampMetrikaCountersChangeToObject)
                .build())

        tableChangesHandler.addTableChange(
            TableChange.Builder<BsExportBannerResourcesObject>()
                .setTable(CAMP_METRIKA_COUNTERS)
                .setOperation(Operation.UPDATE)
                .setColumn(CAMP_METRIKA_COUNTERS.METRIKA_COUNTERS)
                .setMapper(this::mapCampMetrikaCountersChangeToObject)
                .build())

        tableChangesHandler.addTableChange(
            TableChange.Builder<BsExportBannerResourcesObject>()
                .setTable(CAMP_METRIKA_COUNTERS)
                .setOperation(Operation.DELETE)
                .setMapper(this::mapCampMetrikaCountersChangeToObject)
                .build())
    }

    override fun mapToObject(proceededChange: ProceededChange): BsExportBannerResourcesObject {
        return BsExportBannerResourcesObject.Builder()
            .setBid(proceededChange.getPrimaryKey(BANNER_PUBLISHER.BID))
            .setResourceType(bannerResourceType())
            .build()
    }

    private fun mapCampMetrikaCountersChangeToObject(proceededChange: ProceededChange): BsExportBannerResourcesObject? {
        val cid: Long = proceededChange.getPrimaryKey(CAMP_METRIKA_COUNTERS.CID)
        return BsExportBannerResourcesObject.Builder()
            .setAdditionalId(cid)
            .setAdditionalTable(TablesEnum.CAMP_METRIKA_COUNTERS)
            .setResourceType(bannerResourceType())
            .build()
    }
}
