package ru.yandex.direct.ess.router.rules.bsexport.resources.filter;

import java.util.ArrayList;
import java.util.List;

import org.jooq.Named;

import ru.yandex.direct.binlog.model.Operation;
import ru.yandex.direct.dbschema.ppc.enums.BannersStatusmoderate;
import ru.yandex.direct.ess.logicobjects.bsexport.resources.BannerResourceType;
import ru.yandex.direct.ess.logicobjects.bsexport.resources.BsExportBannerResourcesObject;
import ru.yandex.direct.ess.router.utils.ProceededChange;
import ru.yandex.direct.ess.router.utils.TableChange;
import ru.yandex.direct.ess.router.utils.TableChangesHandler;

import static ru.yandex.direct.dbschema.ppc.Tables.BANNERS;
import static ru.yandex.direct.ess.router.utils.ColumnsChangeType.ANY;

/**
 * Базовый класс для ресурсов баннера, находящихся в таблице banners
 */
public abstract class BaseBannerFilter implements IBannerResourceFilter {


    @Override
    public void init(TableChangesHandler<BsExportBannerResourcesObject> tableChangesHandler) {
        tableChangesHandler.addTableChange(
                new TableChange.Builder<BsExportBannerResourcesObject>()
                        .setTable(BANNERS)
                        .setOperation(Operation.INSERT)
                        .setValuesFilter(this::checkBannerInternal)
                        .setMapper(this::mapToObject)
                        .build()

        );

        var observableColumns = new ArrayList<>(getObservableColumns());
        observableColumns.add(BANNERS.STATUS_MODERATE);
        tableChangesHandler.addTableChange(
                new TableChange.Builder<BsExportBannerResourcesObject>()
                        .setTable(BANNERS)
                        .setOperation(Operation.UPDATE)
                        .setColumns(ANY, observableColumns)
                        .setValuesFilter(this::checkBannerInternal)
                        .setMapper(this::mapToObject)
                        .build()

        );
    }

    abstract List<Named> getObservableColumns();

    abstract BannerResourceType bannerResourceType();

    private boolean checkBannerInternal(ProceededChange proceededChange) {
        return checkBanner(proceededChange) && checkStatusModerate(proceededChange);
    }

    boolean checkBanner(ProceededChange proceededChange) {
        return true;
    }

    boolean checkStatusModerate(ProceededChange proceededChange) {
        if (!proceededChange.afterContains(BANNERS.STATUS_MODERATE)) {
            return true;
        }
        var statusModerate = proceededChange.getAfter(BANNERS.STATUS_MODERATE);
        return BannersStatusmoderate.Yes.getLiteral().equals(statusModerate);
    }

    protected BsExportBannerResourcesObject mapToObject(ProceededChange proceededChange) {
        return new BsExportBannerResourcesObject.Builder()
                .setBid(proceededChange.getPrimaryKey(BANNERS.BID))
                .setPid(proceededChange.getAfter(BANNERS.PID))
                .setCid(proceededChange.getAfter(BANNERS.CID))
                .setReqid(proceededChange.getReqId())
                .setService(proceededChange.getService())
                .setMethod(proceededChange.getMethod())
                .setResourceType(bannerResourceType())
                .build();
    }
}
