package ru.yandex.direct.ess.router.rules.bsexport.resources.filter;

import java.util.List;

import org.jooq.Named;
import org.jooq.Table;

import ru.yandex.direct.binlog.model.Operation;
import ru.yandex.direct.ess.logicobjects.bsexport.resources.BannerResourceType;
import ru.yandex.direct.ess.logicobjects.bsexport.resources.BsExportBannerResourcesObject;
import ru.yandex.direct.ess.logicobjects.bsexport.resources.DebugInfo;
import ru.yandex.direct.ess.router.utils.ColumnsChangeType;
import ru.yandex.direct.ess.router.utils.ProceededChange;
import ru.yandex.direct.ess.router.utils.TableChange;
import ru.yandex.direct.ess.router.utils.TableChangesHandler;

/**
 * Базовый класс для ресурсов баннера, находящихся не в таблице banners, а в связанных
 */
public abstract class BaseBannerResourceFilter implements IBannerResourceFilter {
    @Override
    public void init(TableChangesHandler<BsExportBannerResourcesObject> tableChangesHandler) {
        addBaseTableChanges(tableChangesHandler);
        addAdditionalChanges(tableChangesHandler);
    }

    public abstract BannerResourceType bannerResourceType();

    protected abstract Table<?> getResourceTable();

    protected abstract boolean checkStatusModerate(ProceededChange proceededChange);

    protected abstract BsExportBannerResourcesObject mapToObject(ProceededChange proceededChange);

    void addAdditionalChanges(TableChangesHandler<BsExportBannerResourcesObject> tableChangesHandler) {

    }

    /**
     * Список колонок, за которыми следить при апдейте
     */
    List<Named> observableColumns() {
        return null;
    }

    public void addBaseTableChanges(TableChangesHandler<BsExportBannerResourcesObject> tableChangesHandler) {
        tableChangesHandler.addTableChange(
                new TableChange.Builder<BsExportBannerResourcesObject>()
                        .setTable(getResourceTable())
                        .setOperation(Operation.INSERT)
                        .setValuesFilter(this::checkStatusModerate)
                        .setMapper(this::mapToObjectInternal)
                        .build()

        );

        var updateChangeBuilder = new TableChange.Builder<BsExportBannerResourcesObject>()
                .setTable(getResourceTable())
                .setOperation(Operation.UPDATE);
        if (observableColumns() != null) {
            updateChangeBuilder = updateChangeBuilder.setColumns(ColumnsChangeType.ANY, observableColumns());
        }
        updateChangeBuilder = updateChangeBuilder
                .setValuesFilter(this::checkStatusModerate)
                .setMapper(this::mapToObjectInternal);
        tableChangesHandler.addTableChange(updateChangeBuilder.build());

        tableChangesHandler.addTableChange(
                new TableChange.Builder<BsExportBannerResourcesObject>()
                        .setTable(getResourceTable())
                        .setOperation(Operation.DELETE)
                        .setMapper(this::mapToDeletedObject)
                        .build()

        );
    }

    BsExportBannerResourcesObject mapToObjectInternal(ProceededChange proceededChange) {
        var object = mapToObject(proceededChange);
        addDebugInfo(object, proceededChange);
        return object;
    }

    static void addDebugInfo(BsExportBannerResourcesObject object, ProceededChange change) {
        var debugInfo = new DebugInfo(change.getReqId(), change.getService(), change.getMethod());
        object.setDebugInfo(debugInfo);
    }

    private BsExportBannerResourcesObject mapToDeletedObject(ProceededChange proceededChange) {
        var object = mapToObjectInternal(proceededChange);
        object.setDeleted(true);
        return object;
    }
}
