package ru.yandex.direct.ess.router.rules.bsexport.strategy

import ru.yandex.direct.binlog.model.BinlogEvent
import ru.yandex.direct.ess.config.bsexport.BsExportStrategyConfig
import ru.yandex.direct.ess.logicobjects.bsexport.strategy.BsExportStrategyObject
import ru.yandex.direct.ess.router.models.rule.AbstractRule
import ru.yandex.direct.ess.router.models.rule.EssRule
import ru.yandex.direct.ess.router.rules.bsexport.strategy.filter.BaseStrategyFilter
import ru.yandex.direct.ess.router.utils.TableChangesHandler

@EssRule(BsExportStrategyConfig::class)
class BsExportStrategyRule(filters: List<BaseStrategyFilter>) : AbstractRule<BsExportStrategyObject>() {
    private val tableChangesHandler: TableChangesHandler<BsExportStrategyObject> = TableChangesHandler()

    init {
        filters.forEach {
            it.init(tableChangesHandler)
        }
    }

    override fun mapBinlogEvent(binlogEvent: BinlogEvent?): List<BsExportStrategyObject> {
        return tableChangesHandler.processChanges(binlogEvent)
    }
}
