package ru.yandex.direct.ess.router.rules.bsexport.strategy.filter

import ru.yandex.direct.ess.logicobjects.bsexport.strategy.BsExportStrategyObject
import ru.yandex.direct.ess.logicobjects.bsexport.strategy.StrategyResourceType
import ru.yandex.direct.ess.router.utils.ProceededChange
import ru.yandex.direct.ess.router.utils.TableChangesHandler

abstract class BaseStrategyFilter {
    abstract val strategyResourceType: StrategyResourceType;

    abstract fun init(tableChangesHandler: TableChangesHandler<BsExportStrategyObject>)

    open fun initStrategyObject(proceededChange: ProceededChange, strategyId: Long): BsExportStrategyObject {
        return BsExportStrategyObject(strategyId, strategyResourceType, proceededChange.reqId, proceededChange.service, proceededChange.method)
    }
}
