package ru.yandex.direct.ess.router.rules.bsexport.strategy.filter

import org.springframework.stereotype.Component
import ru.yandex.direct.binlog.model.Operation
import ru.yandex.direct.dbschema.ppc.Tables
import ru.yandex.direct.ess.logicobjects.bsexport.strategy.BsExportStrategyObject
import ru.yandex.direct.ess.logicobjects.bsexport.strategy.StrategyResourceType
import ru.yandex.direct.ess.router.utils.ColumnsChangeType
import ru.yandex.direct.ess.router.utils.ProceededChange
import ru.yandex.direct.ess.router.utils.TableChange
import ru.yandex.direct.ess.router.utils.TableChangesHandler

@Component
class StrategyAutobudgetRestartFieldsFilter : BaseStrategyFilter() {

    override val strategyResourceType: StrategyResourceType = StrategyResourceType.AUTOBUDGET_RESTART

    override fun init(tableChangesHandler: TableChangesHandler<BsExportStrategyObject>) {
        tableChangesHandler.addTableChange(buildInsertTableChange())
        tableChangesHandler.addTableChange(buildUpdateTableChange())
    }

    private fun buildUpdateTableChange(): TableChange<BsExportStrategyObject> =
        TableChange.Builder<BsExportStrategyObject>()
            .setTable(Tables.STRATEGY_AUTOBUDGET_RESTART)
            .setOperation(Operation.UPDATE)
            .setColumns(
                ColumnsChangeType.ANY,
                listOf(
                    Tables.STRATEGY_AUTOBUDGET_RESTART.RESTART_TIME,
                    Tables.STRATEGY_AUTOBUDGET_RESTART.SOFT_RESTART_TIME,
                    Tables.STRATEGY_AUTOBUDGET_RESTART.STOP_TIME,
                    Tables.STRATEGY_AUTOBUDGET_RESTART.RESTART_REASON
                )
            )
            .setMapper(this::mapToStrategyObject)
            .build()

    private fun buildInsertTableChange(): TableChange<BsExportStrategyObject> =
        TableChange.Builder<BsExportStrategyObject>()
            .setTable(Tables.STRATEGY_AUTOBUDGET_RESTART)
            .setOperation(Operation.INSERT)
            .setMapper(this::mapToStrategyObject)
            .build()

    private fun mapToStrategyObject(proceededChange: ProceededChange): BsExportStrategyObject {
        return initStrategyObject(
            proceededChange,
            proceededChange.getPrimaryKey(Tables.STRATEGY_AUTOBUDGET_RESTART.STRATEGY_ID)
        )
    }
}
