package ru.yandex.direct.ess.router.rules.bsexport.strategy.filter

import org.springframework.stereotype.Component
import ru.yandex.direct.binlog.model.Operation
import ru.yandex.direct.dbschema.ppc.Tables
import ru.yandex.direct.ess.logicobjects.bsexport.strategy.BsExportStrategyObject
import ru.yandex.direct.ess.logicobjects.bsexport.strategy.StrategyResourceType
import ru.yandex.direct.ess.router.utils.ColumnsChangeType
import ru.yandex.direct.ess.router.utils.ProceededChange
import ru.yandex.direct.ess.router.utils.TableChange
import ru.yandex.direct.ess.router.utils.TableChangesHandler

@Component
class StrategyCommonFieldsFilter : BaseStrategyFilter() {
    override val strategyResourceType = StrategyResourceType.COMMON_FIELDS;

    override fun init(tableChangesHandler: TableChangesHandler<BsExportStrategyObject>) {
        tableChangesHandler.addTableChange(
            TableChange.Builder<BsExportStrategyObject>()
                .setTable(Tables.STRATEGIES)
                .setOperation(Operation.INSERT)
                .setMapper(this::mapToStrategyObject)
                .build()
        )

        tableChangesHandler.addTableChange(
            TableChange.Builder<BsExportStrategyObject>()
                .setTable(Tables.STRATEGIES)
                .setOperation(Operation.UPDATE)
                .setColumns(
                    ColumnsChangeType.ANY, listOf(
                        Tables.STRATEGIES.TYPE,
                        Tables.STRATEGIES.CLIENT_ID,
                        Tables.STRATEGIES.WALLET_CID,
                        Tables.STRATEGIES.TYPE,
                        Tables.STRATEGIES.ATTRIBUTION_MODEL,
                        Tables.STRATEGIES.STRATEGY_DATA,
                        Tables.STRATEGIES.ARCHIVED,
                    )
                )
                .setMapper(this::mapToStrategyObject)
                .build()
        )
    }

    private fun mapToStrategyObject(proceededChange: ProceededChange): BsExportStrategyObject {
        return initStrategyObject(proceededChange, proceededChange.getPrimaryKey(Tables.STRATEGIES.STRATEGY_ID))
    }
}
