package ru.yandex.direct.ess.router.rules.bsexport.strategy.filter

import org.springframework.stereotype.Component
import ru.yandex.direct.binlog.model.Operation
import ru.yandex.direct.dbschema.ppc.Tables
import ru.yandex.direct.ess.logicobjects.bsexport.strategy.BsExportStrategyObject
import ru.yandex.direct.ess.logicobjects.bsexport.strategy.StrategyResourceType
import ru.yandex.direct.ess.router.utils.ColumnsChangeType
import ru.yandex.direct.ess.router.utils.ProceededChange
import ru.yandex.direct.ess.router.utils.TableChange
import ru.yandex.direct.ess.router.utils.TableChangesHandler

@Component
class StrategyDayBudgetFilter : BaseStrategyFilter(){
    override val strategyResourceType = StrategyResourceType.DAY_BUDGET

    override fun init(tableChangesHandler: TableChangesHandler<BsExportStrategyObject>) {
        tableChangesHandler.addTableChange(
            TableChange.Builder<BsExportStrategyObject>()
                .setTable(Tables.STRATEGIES)
                .setOperation(Operation.INSERT)
                .setMapper(this::mapToStrategyObject)
                .build()
        )

        tableChangesHandler.addTableChange(
            TableChange.Builder<BsExportStrategyObject>()
                .setTable(Tables.STRATEGIES)
                .setOperation(Operation.UPDATE)
                .setColumns(
                    ColumnsChangeType.ANY, listOf(
                        Tables.STRATEGIES.DAY_BUDGET,
                        Tables.STRATEGIES.DAY_BUDGET_SHOW_MODE,
                    )
                )
                .setMapper(this::mapToStrategyObject)
                .build()
        )
    }

    private fun mapToStrategyObject(proceededChange: ProceededChange): BsExportStrategyObject {
        return initStrategyObject(proceededChange, proceededChange.getPrimaryKey(Tables.STRATEGIES.STRATEGY_ID))
    }
}
