package ru.yandex.direct.ess.router.rules.campstatusmoderate;

import ru.yandex.direct.ess.config.campstatusmoderate.CampaignStatusModerateConfig;
import ru.yandex.direct.ess.logicobjects.moderation.campstatusmoderate.CampaignStatusEventsObject;
import ru.yandex.direct.ess.router.models.rule.EssRule;
import ru.yandex.direct.ess.router.models.rule.StandardRule;
import ru.yandex.direct.ess.router.utils.ProceededChange;
import ru.yandex.direct.ess.router.utils.TableChange;

import static ru.yandex.direct.binlog.model.Operation.INSERT;
import static ru.yandex.direct.binlog.model.Operation.UPDATE;
import static ru.yandex.direct.dbschema.ppc.tables.AggrStatusesCampaigns.AGGR_STATUSES_CAMPAIGNS;
import static ru.yandex.direct.ess.router.utils.ProceededChangeUtil.getProceededChangeEssTag;
import static ru.yandex.direct.ess.router.utils.ProceededChangeUtil.getProceededChangeTimestamp;

@EssRule(CampaignStatusModerateConfig.class)
public class CampStatusModerateRule extends StandardRule<CampaignStatusEventsObject> {

    public CampStatusModerateRule() {
        super(tableChangesHandler -> {
            tableChangesHandler.addTableChange(
                    new TableChange.Builder<CampaignStatusEventsObject>()
                            .setTable(AGGR_STATUSES_CAMPAIGNS)
                            .setOperation(INSERT)
                            .setMapper(CampStatusModerateRule::mapChangeToObject)
                            .build());
            tableChangesHandler.addTableChange(
                    new TableChange.Builder<CampaignStatusEventsObject>()
                            .setTable(AGGR_STATUSES_CAMPAIGNS)
                            .setOperation(UPDATE)
                            .setMapper(CampStatusModerateRule::mapChangeToObject)
                            .build());
        });
    }

    private static CampaignStatusEventsObject mapChangeToObject(ProceededChange change) {
        return new CampaignStatusEventsObject(getProceededChangeEssTag(change),
                getProceededChangeTimestamp(change),
                change.getPrimaryKey(AGGR_STATUSES_CAMPAIGNS.CID), false);
    }
}
