package ru.yandex.direct.ess.router.rules.conversioncenter

import ru.yandex.direct.binlog.model.BinlogEvent
import ru.yandex.direct.binlog.model.Operation
import ru.yandex.direct.dbschema.ppc.Tables.CAMPAIGNS
import ru.yandex.direct.ess.config.conversioncenter.ConversionCenterEventConfig
import ru.yandex.direct.ess.logicobjects.conversioncenter.ConversionCenterEventObject
import ru.yandex.direct.ess.router.models.rule.AbstractRule
import ru.yandex.direct.ess.router.models.rule.EssRule
import ru.yandex.direct.ess.router.utils.ProceededChange
import ru.yandex.direct.ess.router.utils.TableChange
import ru.yandex.direct.ess.router.utils.TableChangesHandler

@EssRule(ConversionCenterEventConfig::class)
class ConversionCenterEventRule: AbstractRule<ConversionCenterEventObject>() {
    private val tableChangesHandler = TableChangesHandler<ConversionCenterEventObject>()

    init {
        tableChangesHandler.apply {
            addTableChange(
                TableChange.Builder<ConversionCenterEventObject>()
                    .setTable(CAMPAIGNS)
                    .setOperation(Operation.INSERT)
                    .setMapper { mapChangeToObject(it) }
                    .build()
            )
        }
        tableChangesHandler.apply {
            addTableChange(
                TableChange.Builder<ConversionCenterEventObject>()
                    .setTable(CAMPAIGNS)
                    .setOperation(Operation.UPDATE)
                    .setColumn(CAMPAIGNS.STRATEGY_DATA)
                    .setMapper { mapChangeToObject(it) }
                    .build()
            )
        }
    }

    override fun mapBinlogEvent(event: BinlogEvent?): List<ConversionCenterEventObject> {
        return tableChangesHandler.processChanges(event)
    }

    private fun mapChangeToObject(change: ProceededChange): ConversionCenterEventObject {
        return ConversionCenterEventObject(change.getLongBeforeOrAfter(CAMPAIGNS.CLIENT_ID), change.getPrimaryKey(CAMPAIGNS.CID))
    }
}
