package ru.yandex.direct.ess.router.rules.feeds.statusupdate;

import java.util.List;

import ru.yandex.direct.binlog.model.BinlogEvent;
import ru.yandex.direct.ess.config.feeds.statusupdate.FeedStatusUpdateConfig;
import ru.yandex.direct.ess.logicobjects.feeds.statusupdate.FeedStatusUpdateObject;
import ru.yandex.direct.ess.router.models.rule.AbstractRule;
import ru.yandex.direct.ess.router.models.rule.EssRule;
import ru.yandex.direct.ess.router.utils.ProceededChange;
import ru.yandex.direct.ess.router.utils.TableChange;
import ru.yandex.direct.ess.router.utils.TableChangesHandler;

import static ru.yandex.direct.binlog.model.Operation.UPDATE;
import static ru.yandex.direct.dbschema.ppc.tables.Feeds.FEEDS;

@EssRule(FeedStatusUpdateConfig.class)
public class FeedStatusUpdateRule extends AbstractRule<FeedStatusUpdateObject>  {

    private final TableChangesHandler<FeedStatusUpdateObject> tableChangesHandler = new TableChangesHandler<>();

    public FeedStatusUpdateRule() {
        tableChangesHandler.addTableChange(
                new TableChange.Builder<FeedStatusUpdateObject>()
                        .setTable(FEEDS)
                        .setOperation(UPDATE)
                        .setColumn(FEEDS.UPDATE_STATUS)
                        .setMapper(FeedStatusUpdateRule::mapChangeToObject)
                        .build()
        );
    }

    @Override
    public List<FeedStatusUpdateObject> mapBinlogEvent(BinlogEvent binlogEvent) {
        return tableChangesHandler.processChanges(binlogEvent);
    }

    private static FeedStatusUpdateObject mapChangeToObject(ProceededChange change) {
        return new FeedStatusUpdateObject(change.getBeforeOrAfter(FEEDS.CLIENT_ID));
    }
}
