package ru.yandex.direct.ess.router.rules.feeds.usagetypes

import org.jooq.Field
import ru.yandex.direct.binlog.model.BinlogEvent
import ru.yandex.direct.binlog.model.Operation
import ru.yandex.direct.dbschema.ppc.Tables.FEEDS
import ru.yandex.direct.ess.config.feeds.usagetypes.FeedUsageTypesConfig
import ru.yandex.direct.ess.logicobjects.feeds.usagetypes.FeedUsageTypesObject
import ru.yandex.direct.ess.router.models.rule.AbstractRule
import ru.yandex.direct.ess.router.models.rule.EssRule
import ru.yandex.direct.ess.router.utils.ProceededChange
import ru.yandex.direct.ess.router.utils.TableChange
import ru.yandex.direct.ess.router.utils.TableChangesHandler
import java.math.BigInteger

@EssRule(FeedUsageTypesConfig::class)
class FeedUsageTypesRule : AbstractRule<FeedUsageTypesObject>() {
    private val tableChangesHandler = TableChangesHandler<FeedUsageTypesObject>()

    init {
        tableChangesHandler.addTableChange(
            TableChange.Builder<FeedUsageTypesObject>()
                .setTable(FEEDS)
                .setOperation(Operation.UPDATE)
                .setColumn(FEEDS.USAGE_TYPE)
                .setMapper { obj: ProceededChange -> mapChangeToObject(obj) }
                .build()
        )
    }

    override fun mapBinlogEvent(binlogEvent: BinlogEvent): List<FeedUsageTypesObject> {
        return tableChangesHandler.processChanges(binlogEvent)
    }

    private fun mapChangeToObject(change: ProceededChange): FeedUsageTypesObject {
        return FeedUsageTypesObject(
            getPrimaryKeyLongField(change, FEEDS.FEED_ID),
            null,
            null,
            null,
            Operation.UPDATE
        )
    }

    private fun getPrimaryKeyLongField(proceededChange: ProceededChange, field: Field<Long>): Long? {
        return if (proceededChange.getPrimaryKey<Any, Long>(field) is BigInteger) {
            (proceededChange.getPrimaryKey<Any, Long>(field) as BigInteger).toLong()
        } else {
            proceededChange.getPrimaryKey<Long, Long>(field)
        }
    }
}
